/*
 * Decompiled with CFR 0.152.
 */
package com.github.anicolaspp.ojai;

import com.github.anicolaspp.ojai.DocumentProjector;
import com.github.anicolaspp.ojai.PathProjector;
import java.util.Arrays;
import java.util.Optional;
import org.ojai.Document;
import org.ojai.exceptions.DecodingException;
import org.ojai.store.Connection;

public class LinearProjector
implements PathProjector {
    private Document document;
    private Connection connection;

    public LinearProjector(Document document, Connection connection) {
        this.document = document;
        this.connection = connection;
    }

    @Override
    public Document projectPath(String string) {
        String[] stringArray = string.replace("\"", "").split("\\.");
        String string2 = stringArray[0];
        if (this.isLastSegment(stringArray)) {
            return this.getFinalDocument(string2);
        }
        return this.tryGetSubDoc(string2, this.document).map(document -> {
            Document document2 = new DocumentProjector(this.connection.newDocument((Object)this.document.getValue(string2)), this.connection).projectPath(this.getNextSegments(stringArray));
            return this.connection.newDocument().set(string2, document2);
        }).orElse(this.connection.newDocument());
    }

    private boolean isLastSegment(String[] stringArray) {
        return Arrays.stream(stringArray).skip(1L).reduce("", (string, string2) -> string + string2).isEmpty();
    }

    private String getNextSegments(String[] stringArray) {
        return Arrays.stream(stringArray).skip(1L).reduce("", (string, string2) -> string + string2);
    }

    private Document getFinalDocument(String string) {
        try {
            return this.connection.newDocument().set(string, this.document.getValue(string));
        }
        catch (NullPointerException nullPointerException) {
            return this.connection.newDocument();
        }
    }

    private Optional<Document> tryGetSubDoc(String string, Document document) {
        try {
            Document document2 = this.connection.newDocument((Object)document.getValue(string));
            return Optional.ofNullable(document2);
        }
        catch (DecodingException decodingException) {
            return Optional.empty();
        }
    }
}

