/*
 * Decompiled with CFR 0.152.
 */
package com.at.avro;

import com.at.avro.AvroType;
import com.at.avro.AvroTypeUtil;
import com.at.avro.config.AvroConfig;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import schemacrawler.schema.Column;

public class AvroField {
    private static final Object NOT_SET = new Object();
    private String name;
    private AvroType type;
    private Object defaultValue = NOT_SET;
    private String doc;

    public AvroField(Column column, AvroConfig avroConfig) {
        String columnName = column.getName().replaceAll("`", "").replaceAll("\"", "").replaceAll("'", "");
        this.name = avroConfig.getFieldNameMapper().apply(columnName);
        this.type = AvroTypeUtil.getAvroType(column, avroConfig);
        if (avroConfig.isAllFieldsDefaultNull()) {
            this.defaultValue = null;
        } else if (column.getDefaultValue() != null) {
            Object object = this.defaultValue = column.getDefaultValue().contains("NULL") ? null : this.defaultValue;
        }
        if (avroConfig.isUseSqlCommentsAsDoc()) {
            this.doc = column.getRemarks();
        }
    }

    public String getName() {
        return this.name;
    }

    public AvroType getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isDefaultValueSet() {
        return this.defaultValue != NOT_SET;
    }

    public String getDoc() {
        return this.doc;
    }

    public boolean isDocSet() {
        return StringUtils.isNotBlank((CharSequence)this.doc);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", AvroField.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("type=" + this.type);
        if (this.defaultValue != NOT_SET) {
            joiner.add("defaultValue=" + this.defaultValue);
        }
        if (this.isDocSet()) {
            joiner.add("doc='" + this.doc + "'");
        }
        return joiner.toString();
    }
}

