/*
 * Decompiled with CFR 0.152.
 */
package com.at.avro;

import com.at.avro.AvroField;
import com.at.avro.config.AvroConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;

public class AvroSchema {
    private final String name;
    private final String namespace;
    private final String doc;
    private List<AvroField> fields;
    private Map<String, String> customProperties = new LinkedHashMap<String, String>();

    public AvroSchema(Table table, AvroConfig avroConfig) {
        this.name = avroConfig.getSchemaNameMapper().apply(table.getName());
        this.namespace = avroConfig.getNamespace();
        this.doc = avroConfig.isUseSqlCommentsAsDoc() ? table.getRemarks() : null;
        this.fields = new ArrayList<AvroField>(table.getColumns().size());
        for (Column column : table.getColumns()) {
            this.fields.add(new AvroField(column, avroConfig));
        }
        avroConfig.getAvroSchemaPostProcessor().accept(this, table);
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDoc() {
        return this.doc;
    }

    public boolean isDocSet() {
        return StringUtils.isNotBlank((CharSequence)this.doc);
    }

    public List<AvroField> getFields() {
        return this.fields;
    }

    public void addCustomProperty(String name, String value) {
        this.customProperties.put(name, value);
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", AvroSchema.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("namespace='" + this.namespace + "'");
        if (this.isDocSet()) {
            joiner.add("doc='" + this.doc + "'");
        }
        joiner.add("fields=" + this.fields).add("customProperties=" + this.customProperties);
        return joiner.toString();
    }
}

