/*
 * Decompiled with CFR 0.152.
 */
package com.at.avro;

import com.at.avro.AvroSchema;
import com.at.avro.config.AvroConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.tools.utility.SchemaCrawlerUtility;

public class DbSchemaExtractor {
    private final String connectionUrl;
    private final Properties connectionProperties = new Properties();

    public DbSchemaExtractor(String connectionUrl, String user, String password) {
        this.connectionProperties.put("nullNamePatternMatchesAll", "true");
        this.connectionProperties.put("user", user);
        this.connectionProperties.put("password", password);
        this.connectionUrl = connectionUrl;
    }

    public List<AvroSchema> getAll(AvroConfig avroConfig) {
        return this.get(avroConfig, null, new String[0]);
    }

    public List<AvroSchema> getForSchema(AvroConfig avroConfig, String dbSchemaName) {
        return this.get(avroConfig, dbSchemaName, new String[0]);
    }

    public List<AvroSchema> getForTables(AvroConfig avroConfig, String dbSchemaName, String ... tableNames) {
        return this.get(avroConfig, dbSchemaName, tableNames);
    }

    public AvroSchema getForTable(AvroConfig avroConfig, String dbSchemaName, String tableName) {
        List<AvroSchema> schemas = this.get(avroConfig, dbSchemaName, tableName);
        if (schemas.isEmpty()) {
            return null;
        }
        return schemas.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AvroSchema> get(AvroConfig avroConfig, String dbSchemaName, String ... tableNames) {
        try (Connection connection = DriverManager.getConnection(this.connectionUrl, this.connectionProperties);){
            SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
            options = options.withLoadOptions(LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.maximum()).toOptions());
            LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
            if (dbSchemaName != null) {
                String schemaPattern = ".*((?i)" + dbSchemaName + ")";
                limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionInclusionRule(schemaPattern));
            }
            if (tableNames.length == 1) {
                limitOptionsBuilder.tableNamePattern(tableNames[0]);
            }
            options = options.withLimitOptions(limitOptionsBuilder.toOptions());
            Catalog catalog = SchemaCrawlerUtility.getCatalog((Connection)connection, (SchemaCrawlerOptions)options);
            List<Object> dbSchemas = new ArrayList(catalog.getSchemas());
            if (dbSchemaName != null) {
                dbSchemas = dbSchemas.stream().filter(schema -> dbSchemaName.equalsIgnoreCase(schema.getCatalogName()) || dbSchemaName.equalsIgnoreCase(schema.getName()) || dbSchemaName.equalsIgnoreCase(Identifiers.STANDARD.quoteName(schema.getName()))).collect(Collectors.toList());
            }
            LinkedList<AvroSchema> schemas = new LinkedList<AvroSchema>();
            for (Schema dbSchema : dbSchemas) {
                for (Table table : catalog.getTables(dbSchema)) {
                    if (tableNames.length != 0 && !this.containsIgnoreCase(tableNames, table.getName())) continue;
                    schemas.add(new AvroSchema(table, avroConfig));
                }
            }
            LinkedList<AvroSchema> linkedList = schemas;
            return linkedList;
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("Can not get connection to " + this.connectionUrl, e);
        }
        catch (SchemaCrawlerException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean containsIgnoreCase(String[] array, String word) {
        for (String s : array) {
            if (!s.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }
}

