/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import akka.Main;
import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.routing.ActorRefRoutee;
import akka.routing.BroadcastRoutingLogic;
import akka.routing.Routee;
import akka.routing.Router;
import akka.routing.RoutingLogic;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public final class Simulator
extends AbstractActor {
    private TraceReader traceReader;
    private BasicSettings settings;
    private Stopwatch stopwatch;
    private Reporter reporter;
    private Router router;

    public void preStart() {
        this.self().tell((Object)Message.INIT, this.self());
    }

    public void preRestart(Throwable t, Optional<Object> message) {
        this.context().stop(this.self());
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().matchEquals((Object)Message.INIT, msg -> this.initialize()).matchEquals((Object)Message.START, msg -> this.broadcast()).matchEquals((Object)Message.ERROR, msg -> this.context().stop(this.self())).match(PolicyStats.class, this::reportStats).build();
    }

    private void initialize() {
        Config config = this.context().system().settings().config().getConfig("caffeine.simulator");
        this.settings = new BasicSettings(config);
        this.traceReader = this.makeTraceReader();
        this.stopwatch = Stopwatch.createStarted();
        this.router = new Router((RoutingLogic)new BroadcastRoutingLogic(), this.makeRoutes());
        this.reporter = this.settings.report().format().create(config, this.traceReader.characteristics());
        this.self().tell((Object)Message.START, this.self());
    }

    private void broadcast() {
        if (JavaConverters.seqAsJavaList((Seq)this.router.routees()).isEmpty()) {
            this.context().system().log().error("No active policies in the current configuration");
            this.context().stop(this.self());
            return;
        }
        long skip = this.settings.trace().skip();
        long limit = this.settings.trace().limit();
        int batchSize = this.settings.batchSize();
        try (Stream<AccessEvent> events = this.traceReader.events().skip(skip).limit(limit);){
            MutableObject batch = new MutableObject(new ArrayList(batchSize));
            events.forEach(arg_0 -> this.lambda$broadcast$3((Mutable)batch, batchSize, arg_0));
            this.router.route(batch.getValue(), this.self());
            this.router.route((Object)Message.FINISH, this.self());
        }
    }

    private TraceReader makeTraceReader() {
        if (this.settings.trace().isSynthetic()) {
            return Synthetic.generate(this.settings.trace());
        }
        List<String> filePaths = this.settings.trace().traceFiles().paths();
        TraceFormat format = this.settings.trace().traceFiles().format();
        return format.readFiles(filePaths);
    }

    private List<Routee> makeRoutes() {
        return new Registry(this.settings, this.traceReader.characteristics()).policies().stream().map(policy -> {
            ActorRef actorRef = this.context().actorOf(Props.create(PolicyActor.class, (Object[])new Object[]{policy}));
            this.context().watch(actorRef);
            return new ActorRefRoutee(actorRef);
        }).collect(Collectors.toList());
    }

    private void reportStats(PolicyStats stats) throws IOException {
        this.reporter.add(stats);
        if (this.reporter.stats().size() == JavaConverters.seqAsJavaList((Seq)this.router.routees()).size()) {
            this.reporter.print();
            this.context().stop(this.self());
            System.out.println("Executed in " + this.stopwatch);
        }
    }

    public static void main(String[] args) {
        Main.main((String[])new String[]{Simulator.class.getName()});
    }

    private /* synthetic */ void lambda$broadcast$3(Mutable batch, int batchSize, AccessEvent event) {
        ((List)batch.getValue()).add(event);
        if (((List)batch.getValue()).size() == batchSize) {
            this.router.route(batch.getValue(), this.self());
            batch.setValue(new ArrayList(batchSize));
        }
    }

    public static enum Message {
        INIT,
        START,
        FINISH,
        ERROR;

    }
}

