/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashFunctionParser;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinySetIndexing;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Random;

public final class TinyCache {
    private final HashFunctionParser hashFunc;
    private final TinySetIndexing indexing;
    private final long[] chainIndex;
    private final long[] lastIndex;
    private final int itemsPerSet;
    private final long[] cache;
    private final Random rnd;

    public TinyCache(int nrSets, int itemsPerSet, int randomSeed) {
        this.hashFunc = new HashFunctionParser(nrSets);
        this.cache = new long[nrSets * itemsPerSet];
        this.indexing = new TinySetIndexing();
        this.chainIndex = new long[nrSets];
        this.lastIndex = new long[nrSets];
        this.rnd = new Random(randomSeed);
        this.itemsPerSet = itemsPerSet;
    }

    public boolean contains(long item) {
        this.hashFunc.createHash(item);
        if (!this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], this.hashFunc.fpaux.chainId)) {
            return false;
        }
        this.indexing.getChain(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        int offset = this.itemsPerSet * this.hashFunc.fpaux.set;
        this.indexing.chainStart += offset;
        this.indexing.chainEnd += offset;
        while (this.indexing.chainStart <= this.indexing.chainEnd) {
            try {
                if (this.cache[this.indexing.chainStart % this.cache.length] == this.hashFunc.fpaux.value) {
                    return true;
                }
                ++this.indexing.chainStart;
            }
            catch (RuntimeException e) {
                System.out.println("length: " + this.cache.length + " Access: " + this.indexing.chainStart);
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    private int replace(HashedItem fpaux, byte victim, int bucketStart, int removedOffset) {
        byte chainId = fpaux.chainId;
        fpaux.chainId = victim;
        this.cache[bucketStart + removedOffset] = 0L;
        this.indexing.removeItem(fpaux, this.chainIndex, this.lastIndex);
        fpaux.chainId = chainId;
        int idxToAdd = this.indexing.addItem(fpaux, this.chainIndex, this.lastIndex);
        int delta = removedOffset < idxToAdd ? -1 : 1;
        this.replaceItems(idxToAdd, fpaux.value, bucketStart, delta);
        return removedOffset;
    }

    public boolean addItem(long item) {
        this.hashFunc.createHash(item);
        int bucketStart = this.itemsPerSet * this.hashFunc.fpaux.set;
        if (this.cache[bucketStart + this.itemsPerSet - 1] != 0L) {
            return this.selectVictim(bucketStart);
        }
        int idxToAdd = this.indexing.addItem(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        this.replaceItems(idxToAdd, this.hashFunc.fpaux.value, bucketStart, 1);
        return false;
    }

    private boolean selectVictim(int bucketStart) {
        byte victimOffset = (byte)this.rnd.nextInt(this.itemsPerSet);
        int victimChain = this.indexing.getChainAtOffset(this.hashFunc.fpaux, this.chainIndex, this.lastIndex, victimOffset);
        if (this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], victimChain)) {
            this.replace(this.hashFunc.fpaux, (byte)victimChain, bucketStart, victimOffset);
            return true;
        }
        throw new RuntimeException("Failed to replace");
    }

    private void replaceItems(int idx, long value, int start, int delta) {
        start += idx;
        do {
            long entry = this.cache[start];
            this.cache[start] = value;
            value = entry;
            start += delta;
        } while (value != 0L);
    }
}

