/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashFunctionParser;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinySetIndexing;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Random;

public final class TinyCacheSketch {
    private final HashFunctionParser hashFunc;
    private final TinySetIndexing indexing;
    private final long[] chainIndex;
    private final long[] lastIndex;
    private final int itemsPerSet;
    private final byte[] cache;
    private final Random rnd;

    public TinyCacheSketch(int nrSets, int itemsPerSet, int randomSeed) {
        this.hashFunc = new HashFunctionParser(nrSets);
        this.cache = new byte[nrSets * itemsPerSet];
        this.indexing = new TinySetIndexing();
        this.chainIndex = new long[nrSets];
        this.lastIndex = new long[nrSets];
        this.rnd = new Random(randomSeed);
        this.itemsPerSet = itemsPerSet;
    }

    public int countItem(long item) {
        this.hashFunc.createHash(item);
        if (!this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], this.hashFunc.fpaux.chainId)) {
            return 0;
        }
        this.indexing.getChain(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        int offset = this.itemsPerSet * this.hashFunc.fpaux.set;
        this.indexing.chainStart += offset;
        this.indexing.chainEnd += offset;
        int count = 0;
        while (this.indexing.chainStart <= this.indexing.chainEnd) {
            try {
                if (this.cache[this.indexing.chainStart % this.cache.length] == this.hashFunc.fpaux.fingerprint) {
                    ++count;
                }
                ++this.indexing.chainStart;
            }
            catch (RuntimeException e) {
                System.out.println("length: " + this.cache.length + " Access: " + this.indexing.chainStart);
            }
        }
        return count;
    }

    @CanIgnoreReturnValue
    private int replace(HashedItem fpaux, byte victim, int bucketStart, int removedOffset) {
        byte chainId = fpaux.chainId;
        fpaux.chainId = victim;
        this.cache[bucketStart + removedOffset] = 0;
        this.indexing.removeItem(fpaux, this.chainIndex, this.lastIndex);
        fpaux.chainId = chainId;
        int idxToAdd = this.indexing.addItem(fpaux, this.chainIndex, this.lastIndex);
        int delta = removedOffset < idxToAdd ? -1 : 1;
        this.replaceItems(idxToAdd, fpaux.fingerprint, bucketStart, delta);
        return removedOffset;
    }

    public void addItem(long item) {
        this.hashFunc.createHash(item);
        int bucketStart = this.itemsPerSet * this.hashFunc.fpaux.set;
        if (this.cache[bucketStart + this.itemsPerSet - 1] != 0) {
            this.selectVictim(bucketStart);
            return;
        }
        int idxToAdd = this.indexing.addItem(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        this.replaceItems(idxToAdd, this.hashFunc.fpaux.fingerprint, bucketStart, 1);
    }

    private void selectVictim(int bucketStart) {
        byte victimOffset = (byte)this.rnd.nextInt(this.itemsPerSet);
        int victimChain = this.indexing.getChainAtOffset(this.hashFunc.fpaux, this.chainIndex, this.lastIndex, victimOffset);
        if (!this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], victimChain)) {
            throw new RuntimeException("Failed to replace");
        }
        this.replace(this.hashFunc.fpaux, (byte)victimChain, bucketStart, victimOffset);
    }

    private void replaceItems(int idx, byte value, int start, int delta) {
        start += idx;
        do {
            byte entry = this.cache[start];
            this.cache[start] = value;
            value = entry;
            start += delta;
        } while (value != 0);
    }
}

