/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.gitlog.renderers;

import com.github.danielflower.mavenplugins.gitlog.renderers.ChangeLogRenderer;
import com.github.danielflower.mavenplugins.gitlog.renderers.Formatter;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;

public class MavenLoggerRenderer
implements ChangeLogRenderer {
    private final Log log;
    private boolean previousWasTag = false;

    public MavenLoggerRenderer(Log log) {
        if (log == null) {
            log = new SystemStreamLog();
        }
        this.log = log;
    }

    @Override
    public void renderHeader(String reportTitle) throws IOException {
        this.log.info((CharSequence)"*********************************************");
        this.log.info((CharSequence)reportTitle);
        this.log.info((CharSequence)"*********************************************");
    }

    @Override
    public void renderTag(RevTag tag) throws IOException {
        if (!this.previousWasTag) {
            this.log.info((CharSequence)"");
        }
        this.log.info((CharSequence)tag.getTagName());
        this.previousWasTag = true;
    }

    @Override
    public void renderCommit(RevCommit commit) throws IOException {
        this.log.info((CharSequence)(Formatter.formatDateTime(commit.getCommitTime()) + " " + commit.getShortMessage() + " " + Formatter.formatCommiter(commit.getCommitterIdent())));
        this.previousWasTag = false;
    }

    @Override
    public void renderFooter() throws IOException {
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"*********************************************");
    }

    @Override
    public void close() {
    }
}

