/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.junit;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;

public final class Asserts {
    private Asserts() {
    }

    public static void assertIsUtilityClass(Class<?> cls) {
        Asserts.assertFinal(cls);
        Asserts.assertConstructorIsPrivateAndCall(cls);
        Asserts.assertOnlyStaticMethods(cls);
    }

    static void assertConstructorIsPrivateAndCall(Class<?> cls) {
        Constructor<?> constructor;
        try {
            constructor = cls.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException("private constructor without arguments not found", e1);
        }
        catch (SecurityException e1) {
            throw new RuntimeException(e1);
        }
        Assert.assertTrue((String)"constructor is not private", (boolean)Modifier.isPrivate(constructor.getModifiers()));
        constructor.setAccessible(true);
        try {
            constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    static void assertFinal(Class<?> cls) {
        Assert.assertTrue((String)"class is not final", (boolean)Modifier.isFinal(cls.getModifiers()));
    }

    static void assertOnlyStaticMethods(Class<?> cls) {
        for (Method method : cls.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new AssertionError((Object)("method is not static: " + method.getName()));
            }
        }
    }
}

