/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

final class Util {
    private Util() {
    }

    static byte[] read(InputStream in) throws IOException {
        int n;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((n = in.read(buffer)) != -1) {
            bytes.write(buffer, 0, n);
        }
        return bytes.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] readBytes(Class<?> cls, String resourcePath) {
        try (InputStream in = cls.getResourceAsStream(resourcePath);){
            byte[] byArray = Util.read(in);
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

