/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.internal.util.TextUtils;

public final class LoginAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    private static final List<String> MECHANISMS = new ArrayList<String>(1);
    private final UsernamePasswordValidator helper;

    public LoginAuthenticationHandlerFactory(UsernamePasswordValidator helper) {
        this.helper = helper;
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return MECHANISMS;
    }

    @Override
    public AuthenticationHandler create() {
        return new Handler();
    }

    static {
        MECHANISMS.add("LOGIN");
    }

    final class Handler
    implements AuthenticationHandler {
        private String username;

        Handler() {
        }

        @Override
        public Optional<String> auth(String clientInput, MessageContext context) throws RejectException {
            StringTokenizer stk = new StringTokenizer(clientInput);
            if (stk.hasMoreTokens() && stk.nextToken().trim().equalsIgnoreCase("AUTH")) {
                if (!stk.nextToken().trim().equalsIgnoreCase("LOGIN")) {
                    throw new RejectException(504, "AUTH mechanism mismatch");
                }
                if (stk.hasMoreTokens()) {
                    byte[] decoded = Base64.getDecoder().decode(stk.nextToken());
                    if (decoded == null) {
                        throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
                    }
                    this.username = TextUtils.getStringUtf8(decoded);
                    return Optional.of("334 " + Base64.getEncoder().encodeToString(TextUtils.getAsciiBytes("Password:")));
                }
                return Optional.of("334 " + Base64.getEncoder().encodeToString(TextUtils.getAsciiBytes("Username:")));
            }
            if (this.username == null) {
                byte[] decoded = Base64.getDecoder().decode(clientInput);
                if (decoded == null) {
                    throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
                }
                this.username = TextUtils.getStringUtf8(decoded);
                return Optional.of("334 " + Base64.getEncoder().encodeToString(TextUtils.getAsciiBytes("Password:")));
            }
            byte[] decoded = Base64.getDecoder().decode(clientInput);
            if (decoded == null) {
                throw new RejectException(501, "Invalid command argument, not a valid Base64 string");
            }
            String password = TextUtils.getStringUtf8(decoded);
            try {
                LoginAuthenticationHandlerFactory.this.helper.login(this.username, password, context);
            }
            catch (LoginFailedException lfe) {
                throw new RejectException(535, "Authentication credentials invalid");
            }
            return Optional.empty();
        }

        @Override
        public Object getIdentity() {
            return this.username;
        }
    }
}

