/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.gdata.data.DateTime;

public class DateTimeRange {
    private final DateTime start;
    private final DateTime end;

    public DateTimeRange(DateTime start, DateTime end) {
        this.assertArgumentNotNull(start, "start");
        this.assertArgumentNotNull(end, "end");
        this.start = start;
        this.end = end;
    }

    public DateTimeRange(DateTime dateTime) {
        this(dateTime, dateTime);
    }

    public boolean isDateTimeOnly() {
        return this.start.equals((Object)this.end);
    }

    public DateTime toDateTime() {
        if (!this.isDateTimeOnly()) {
            throw new IllegalStateException("This is a valid range, with distinct start and end date. It cannot be converted to one DateTime value. (Check with isDateTimeOnly() first): " + this);
        }
        return this.start;
    }

    private void assertArgumentNotNull(Object object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " should not be null");
        }
    }

    public DateTime getStart() {
        return this.start;
    }

    public DateTime getEnd() {
        return this.end;
    }

    public String toString() {
        return this.start + " " + this.end;
    }

    public int hashCode() {
        return 37 * this.start.hashCode() + this.end.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateTimeRange)) {
            return false;
        }
        DateTimeRange other = (DateTimeRange)o;
        return other.start.equals((Object)this.start) && other.end.equals((Object)this.end);
    }
}

