/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.finance;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.extensions.Money;
import com.google.gdata.data.finance.Commission;
import com.google.gdata.data.finance.PortfolioData;
import com.google.gdata.data.finance.PortfolioEntry;
import com.google.gdata.data.finance.Price;
import com.google.gdata.data.finance.TransactionData;
import com.google.gdata.data.finance.TransactionEntry;

public class FinanceUtilities {
    private FinanceUtilities() {
    }

    public static PortfolioEntry makePortfolioEntry(String portfolioName, String currencyCode) {
        PortfolioEntry entry = new PortfolioEntry();
        if (!portfolioName.equals("")) {
            entry.setTitle((TextConstruct)new PlainTextConstruct(portfolioName));
        }
        PortfolioData data = new PortfolioData();
        if (!currencyCode.equals("")) {
            data.setCurrencyCode(currencyCode);
        }
        entry.setPortfolioData(data);
        return entry;
    }

    public static TransactionEntry makeTransactionEntry(String type, String date, String shares, String price, String commission, String currency, String notes) {
        TransactionEntry entry = new TransactionEntry();
        TransactionData data = new TransactionData();
        if (type.equals("")) {
            type = "Buy";
        }
        data.setType(type);
        if (!date.equals("")) {
            data.setDate(DateTime.parseDateTime((String)(date + "T00:00:00.000Z")));
        }
        if (!shares.equals("")) {
            data.setShares((double)Double.valueOf(shares));
        }
        if (!price.equals("")) {
            Price p = new Price();
            p.addMoney(new Money(Double.valueOf(Double.valueOf(price)), currency));
            data.setPrice(p);
        }
        if (!commission.equals("")) {
            Commission c = new Commission();
            c.addMoney(new Money(Double.valueOf(Double.valueOf(commission)), currency));
            data.setCommission(c);
        }
        if (!notes.equals("")) {
            data.setNotes(notes);
        }
        entry.setTransactionData(data);
        return entry;
    }
}

