/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.finance;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.finance.CostBasis;
import com.google.gdata.data.finance.DaysGain;
import com.google.gdata.data.finance.Gain;
import com.google.gdata.data.finance.MarketValue;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gf", nsUri="http://schemas.google.com/finance/2007", localName="portfolioData")
public class PortfolioData
extends ExtensionPoint {
    static final String XML_NAME = "portfolioData";
    private static final String CURRENCYCODE = "currencyCode";
    private static final String GAINPERCENTAGE = "gainPercentage";
    private static final String RETURN1W = "return1w";
    private static final String RETURN1Y = "return1y";
    private static final String RETURN3M = "return3m";
    private static final String RETURN3Y = "return3y";
    private static final String RETURN4W = "return4w";
    private static final String RETURN5Y = "return5y";
    private static final String RETURNOVERALL = "returnOverall";
    private static final String RETURNYTD = "returnYTD";
    private String currencyCode = null;
    private Double gainPercentage = null;
    private Double return1w = null;
    private Double return1y = null;
    private Double return3m = null;
    private Double return3y = null;
    private Double return4w = null;
    private Double return5y = null;
    private Double returnOverall = null;
    private Double returnYTD = null;

    public PortfolioData() {
    }

    public PortfolioData(String currencyCode, Double gainPercentage, Double return1w, Double return1y, Double return3m, Double return3y, Double return4w, Double return5y, Double returnOverall, Double returnYTD) {
        this.setCurrencyCode(currencyCode);
        this.setGainPercentage(gainPercentage);
        this.setReturn1w(return1w);
        this.setReturn1y(return1y);
        this.setReturn3m(return3m);
        this.setReturn3y(return3y);
        this.setReturn4w(return4w);
        this.setReturn5y(return5y);
        this.setReturnOverall(returnOverall);
        this.setReturnYTD(returnYTD);
        this.setImmutable(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(PortfolioData.class)) {
            return;
        }
        extProfile.declare(PortfolioData.class, CostBasis.class);
        new CostBasis().declareExtensions(extProfile);
        extProfile.declare(PortfolioData.class, DaysGain.class);
        new DaysGain().declareExtensions(extProfile);
        extProfile.declare(PortfolioData.class, Gain.class);
        new Gain().declareExtensions(extProfile);
        extProfile.declare(PortfolioData.class, MarketValue.class);
        new MarketValue().declareExtensions(extProfile);
    }

    public CostBasis getCostBasis() {
        return (CostBasis)this.getExtension(CostBasis.class);
    }

    public void setCostBasis(CostBasis costBasis) {
        if (costBasis == null) {
            this.removeExtension(CostBasis.class);
        } else {
            this.setExtension((Extension)costBasis);
        }
    }

    public boolean hasCostBasis() {
        return this.hasExtension(CostBasis.class);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.throwExceptionIfImmutable();
        this.currencyCode = currencyCode;
    }

    public boolean hasCurrencyCode() {
        return this.getCurrencyCode() != null;
    }

    public DaysGain getDaysGain() {
        return (DaysGain)this.getExtension(DaysGain.class);
    }

    public void setDaysGain(DaysGain daysGain) {
        if (daysGain == null) {
            this.removeExtension(DaysGain.class);
        } else {
            this.setExtension((Extension)daysGain);
        }
    }

    public boolean hasDaysGain() {
        return this.hasExtension(DaysGain.class);
    }

    public Gain getGain() {
        return (Gain)this.getExtension(Gain.class);
    }

    public void setGain(Gain gain) {
        if (gain == null) {
            this.removeExtension(Gain.class);
        } else {
            this.setExtension((Extension)gain);
        }
    }

    public boolean hasGain() {
        return this.hasExtension(Gain.class);
    }

    public Double getGainPercentage() {
        return this.gainPercentage;
    }

    public void setGainPercentage(Double gainPercentage) {
        this.throwExceptionIfImmutable();
        this.gainPercentage = gainPercentage;
    }

    public boolean hasGainPercentage() {
        return this.getGainPercentage() != null;
    }

    public MarketValue getMarketValue() {
        return (MarketValue)this.getExtension(MarketValue.class);
    }

    public void setMarketValue(MarketValue marketValue) {
        if (marketValue == null) {
            this.removeExtension(MarketValue.class);
        } else {
            this.setExtension((Extension)marketValue);
        }
    }

    public boolean hasMarketValue() {
        return this.hasExtension(MarketValue.class);
    }

    public Double getReturn1w() {
        return this.return1w;
    }

    public void setReturn1w(Double return1w) {
        this.throwExceptionIfImmutable();
        this.return1w = return1w;
    }

    public boolean hasReturn1w() {
        return this.getReturn1w() != null;
    }

    public Double getReturn1y() {
        return this.return1y;
    }

    public void setReturn1y(Double return1y) {
        this.throwExceptionIfImmutable();
        this.return1y = return1y;
    }

    public boolean hasReturn1y() {
        return this.getReturn1y() != null;
    }

    public Double getReturn3m() {
        return this.return3m;
    }

    public void setReturn3m(Double return3m) {
        this.throwExceptionIfImmutable();
        this.return3m = return3m;
    }

    public boolean hasReturn3m() {
        return this.getReturn3m() != null;
    }

    public Double getReturn3y() {
        return this.return3y;
    }

    public void setReturn3y(Double return3y) {
        this.throwExceptionIfImmutable();
        this.return3y = return3y;
    }

    public boolean hasReturn3y() {
        return this.getReturn3y() != null;
    }

    public Double getReturn4w() {
        return this.return4w;
    }

    public void setReturn4w(Double return4w) {
        this.throwExceptionIfImmutable();
        this.return4w = return4w;
    }

    public boolean hasReturn4w() {
        return this.getReturn4w() != null;
    }

    public Double getReturn5y() {
        return this.return5y;
    }

    public void setReturn5y(Double return5y) {
        this.throwExceptionIfImmutable();
        this.return5y = return5y;
    }

    public boolean hasReturn5y() {
        return this.getReturn5y() != null;
    }

    public Double getReturnOverall() {
        return this.returnOverall;
    }

    public void setReturnOverall(Double returnOverall) {
        this.throwExceptionIfImmutable();
        this.returnOverall = returnOverall;
    }

    public boolean hasReturnOverall() {
        return this.getReturnOverall() != null;
    }

    public Double getReturnYTD() {
        return this.returnYTD;
    }

    public void setReturnYTD(Double returnYTD) {
        this.throwExceptionIfImmutable();
        this.returnYTD = returnYTD;
    }

    public boolean hasReturnYTD() {
        return this.getReturnYTD() != null;
    }

    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(PortfolioData.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put((Object)CURRENCYCODE, (Object)this.currencyCode);
        generator.put(GAINPERCENTAGE, (Object)this.gainPercentage);
        generator.put(RETURN1W, (Object)this.return1w);
        generator.put(RETURN1Y, (Object)this.return1y);
        generator.put(RETURN3M, (Object)this.return3m);
        generator.put(RETURN3Y, (Object)this.return3y);
        generator.put(RETURN4W, (Object)this.return4w);
        generator.put(RETURN5Y, (Object)this.return5y);
        generator.put(RETURNOVERALL, (Object)this.returnOverall);
        generator.put(RETURNYTD, (Object)this.returnYTD);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.currencyCode = helper.consume(CURRENCYCODE, false);
        this.gainPercentage = helper.consumeDouble(GAINPERCENTAGE, false);
        this.return1w = helper.consumeDouble(RETURN1W, false);
        this.return1y = helper.consumeDouble(RETURN1Y, false);
        this.return3m = helper.consumeDouble(RETURN3M, false);
        this.return3y = helper.consumeDouble(RETURN3Y, false);
        this.return4w = helper.consumeDouble(RETURN4W, false);
        this.return5y = helper.consumeDouble(RETURN5Y, false);
        this.returnOverall = helper.consumeDouble(RETURNOVERALL, false);
        this.returnYTD = helper.consumeDouble(RETURNYTD, false);
    }

    public String toString() {
        return "{PortfolioData currencyCode=" + this.currencyCode + " gainPercentage=" + this.gainPercentage + " return1w=" + this.return1w + " return1y=" + this.return1y + " return3m=" + this.return3m + " return3y=" + this.return3y + " return4w=" + this.return4w + " return5y=" + this.return5y + " returnOverall=" + this.returnOverall + " returnYTD=" + this.returnYTD + "}";
    }
}

