/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.media.MediaFeed;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.GphotoData;
import com.google.gdata.data.photos.GphotoEntry;
import com.google.gdata.data.photos.impl.GphotoDataImpl;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GphotoFeed<F extends GphotoFeed>
extends MediaFeed<F, GphotoEntry>
implements GphotoData,
AtomData {
    private final GphotoData delegate = new GphotoDataImpl((ExtensionPoint)this);

    public GphotoFeed() {
        this(GphotoEntry.class);
    }

    protected GphotoFeed(Class<? extends GphotoEntry> entryClass) {
        super(entryClass);
    }

    public GphotoFeed(BaseFeed<?, ?> sourceFeed) {
        this(GphotoEntry.class, sourceFeed);
    }

    protected GphotoFeed(Class<? extends GphotoEntry> entryClass, BaseFeed sourceFeed) {
        super(entryClass, sourceFeed);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        this.delegate.declareExtensions(extProfile);
        super.declareExtensions(extProfile);
    }

    public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        Link prevLink = this.getLink("previous", ILink.Type.ATOM);
        Link nextLink = this.getLink("next", ILink.Type.ATOM);
        if (prevLink != null) {
            this.delegate.addRepeatingExtension(new RssLink(prevLink));
        }
        if (nextLink != null) {
            this.delegate.addRepeatingExtension(new RssLink(nextLink));
        }
        super.generateRss(w, extProfile);
    }

    @Override
    public TextConstruct getDescription() {
        return this.getSubtitle();
    }

    @Override
    public void setDescription(TextConstruct description) {
        this.setSubtitle(description);
    }

    @Override
    public String getGphotoId() {
        return this.delegate.getGphotoId();
    }

    @Override
    public void setGphotoId(Long id) {
        this.delegate.setGphotoId(id);
    }

    @Override
    public void setGphotoId(String id) {
        this.delegate.setGphotoId(id);
    }

    private static final class RssLink
    implements Extension {
        private final Link link;

        public RssLink(Link link) {
            this.link = link;
        }

        public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
            this.link.generateAtom(w, extProfile);
        }

        public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
            return null;
        }
    }
}

