/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable;

import be.quodlibet.boxable.BaseTable;
import be.quodlibet.boxable.Cell;
import be.quodlibet.boxable.HorizontalAlignment;
import be.quodlibet.boxable.Paragraph;
import be.quodlibet.boxable.Row;
import be.quodlibet.boxable.VerticalAlignment;
import be.quodlibet.boxable.text.Token;
import be.quodlibet.boxable.utils.FontUtils;
import be.quodlibet.boxable.utils.PDStreamUtils;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCell<T extends PDPage>
extends Cell<T> {
    private static final Logger logger = LoggerFactory.getLogger(TableCell.class);
    private final String tableData;
    private final float width;
    private float yStart;
    private float xStart;
    private float height = 0.0f;
    private final PDDocument doc;
    private final PDPage page;
    private float marginBetweenElementsY = FontUtils.getHeight(this.getFont(), this.getFontSize());
    private final HorizontalAlignment align;
    private final VerticalAlignment valign;
    private PDPageContentStream tableCellContentStream;
    private final float pageTopMargin;
    private final float pageBottomMargin;
    private int tableTitleFontSize = 8;

    TableCell(Row<T> row, float width, String tableData, boolean isCalculated, PDDocument document, PDPage page, float yStart, float pageTopMargin, float pageBottomMargin) {
        this(row, width, tableData, isCalculated, document, page, yStart, pageTopMargin, pageBottomMargin, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    TableCell(Row<T> row, float width, String tableData, boolean isCalculated, PDDocument document, PDPage page, float yStart, float pageTopMargin, float pageBottomMargin, HorizontalAlignment align, VerticalAlignment valign) {
        super(row, width, tableData, isCalculated);
        this.tableData = tableData;
        this.width = width * row.getWidth() / 100.0f;
        this.doc = document;
        this.page = page;
        this.yStart = yStart;
        this.pageTopMargin = pageTopMargin;
        this.pageBottomMargin = pageBottomMargin;
        this.align = align;
        this.valign = valign;
        this.fillTable();
    }

    public void fillTable() {
        try {
            float tableWidth = this.width - this.getLeftPadding() - this.getRightPadding();
            this.tableCellContentStream = new PDPageContentStream(this.doc, this.page, true, true);
            String[] outerTableText = this.tableData.split("<table");
            for (int i = 1; i < outerTableText.length; ++i) {
                outerTableText[i] = "<table " + outerTableText[i];
            }
            Paragraph outerTextParagraph = null;
            String caption = "";
            this.height = 0.0f;
            this.height = (this.getTopBorder() == null ? 0.0f : this.getTopBorder().getWidth()) + this.getTopPadding();
            for (String element : outerTableText) {
                if (element.contains("</table")) {
                    String[] chunks;
                    for (String chunkie : chunks = element.split("</table>")) {
                        if (chunkie.contains("<table")) {
                            Document document = Jsoup.parse((String)chunkie);
                            Element captionTag = document.select("caption").first();
                            Paragraph tableTitle = null;
                            if (captionTag != null) {
                                caption = captionTag.text();
                                tableTitle = new Paragraph(caption, this.getFontBold(), this.tableTitleFontSize, tableWidth, HorizontalAlignment.CENTER, null);
                                this.yStart -= tableTitle.getHeight() + this.marginBetweenElementsY;
                            }
                            this.height += captionTag != null ? tableTitle.getHeight() + this.marginBetweenElementsY : 0.0f;
                            this.createInnerTable(tableWidth, document, this.page, false);
                            continue;
                        }
                        outerTextParagraph = new Paragraph(chunkie, this.getFont(), 8, (int)tableWidth);
                        outerTextParagraph.getLines();
                        this.height += outerTextParagraph != null ? outerTextParagraph.getHeight() + this.marginBetweenElementsY : 0.0f;
                        this.yStart = this.writeOrCalculateParagraph(outerTextParagraph, true);
                    }
                    continue;
                }
                outerTextParagraph = new Paragraph(element, this.getFont(), 8, (int)tableWidth);
                outerTextParagraph.getLines();
                this.height += outerTextParagraph != null ? outerTextParagraph.getHeight() + this.marginBetweenElementsY : 0.0f;
                this.yStart = this.writeOrCalculateParagraph(outerTextParagraph, true);
            }
            this.tableCellContentStream.close();
        }
        catch (IOException e) {
            logger.warn("Cannot create table in TableCell. Table data: '{}' " + this.tableData + e);
        }
    }

    private void createInnerTable(float tableWidth, Document document, PDPage currentPage, boolean drawTable) throws IOException {
        BaseTable table = new BaseTable(this.yStart, PDRectangle.A4.getHeight() - this.pageTopMargin, this.pageTopMargin, this.pageBottomMargin, tableWidth, this.xStart, this.doc, currentPage, true, true);
        document.outputSettings().prettyPrint(false);
        Element htmlTable = document.select("table").first();
        Elements rows = htmlTable.select("tr");
        for (Element htmlTableRow : rows) {
            boolean tableHasHeaderColumns;
            Row row = table.createRow(0.0f);
            Elements tableCols = htmlTableRow.select("td");
            Elements tableHeaderCols = htmlTableRow.select("th");
            boolean bl = tableHasHeaderColumns = !tableHeaderCols.isEmpty();
            if (tableHasHeaderColumns) {
                row.setHeaderRow(true);
            }
            int columnsSize = tableHasHeaderColumns ? tableHeaderCols.size() : tableCols.size();
            for (Element col : tableHasHeaderColumns ? tableHeaderCols : tableCols) {
                if (col.attr("colspan") == null || col.attr("colspan").isEmpty()) continue;
                columnsSize += Integer.parseInt(col.attr("colspan")) - 1;
            }
            for (Element col : tableHasHeaderColumns ? tableHeaderCols : tableCols) {
                Cell cell;
                if (col.attr("colspan") != null && !col.attr("colspan").isEmpty()) {
                    cell = row.createCell(tableWidth / (float)columnsSize * (float)Integer.parseInt(col.attr("colspan")) / row.getWidth() * 100.0f, col.html().replace("&amp;", "&"));
                    continue;
                }
                cell = row.createCell(tableWidth / (float)columnsSize / row.getWidth() * 100.0f, col.html().replace("&amp;", "&"));
            }
            this.yStart -= row.getHeight();
        }
        if (drawTable) {
            table.draw();
        }
        this.height += table.getHeaderAndDataHeight() + this.marginBetweenElementsY;
    }

    private float writeOrCalculateParagraph(Paragraph paragraph, boolean onlyCalculateHeight) throws IOException {
        int boldCounter = 0;
        int italicCounter = 0;
        float cursorY = this.yStart - this.getTopPadding() - FontUtils.getHeight(this.getFont(), this.getFontSize()) - FontUtils.getDescent(this.getFont(), this.getFontSize()) - (this.getTopBorder() == null ? 0.0f : this.getTopBorder().getWidth());
        float cursorX = this.xStart;
        for (Map.Entry<Integer, List<Token>> entry : paragraph.getMapLineTokens().entrySet()) {
            float freeSpaceWithinLine = paragraph.getMaxLineWidth() - paragraph.getLineWidth(entry.getKey());
            if (this.isTextRotated()) {
                switch (this.align) {
                    case CENTER: {
                        cursorY += freeSpaceWithinLine / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorY += freeSpaceWithinLine;
                    }
                }
            } else {
                switch (this.align) {
                    case CENTER: {
                        cursorX += freeSpaceWithinLine / 2.0f;
                        break;
                    }
                    case LEFT: {
                        break;
                    }
                    case RIGHT: {
                        cursorX += freeSpaceWithinLine;
                    }
                }
            }
            PDFont currentFont = paragraph.getFont(false, false);
            for (Token token : entry.getValue()) {
                switch (token.getType()) {
                    case OPEN_TAG: {
                        if ("b".equals(token.getData())) {
                            ++boldCounter;
                            break;
                        }
                        if (!"i".equals(token.getData())) break;
                        ++italicCounter;
                        break;
                    }
                    case CLOSE_TAG: {
                        if ("b".equals(token.getData())) {
                            boldCounter = Math.max(boldCounter - 1, 0);
                            break;
                        }
                        if (!"i".equals(token.getData())) break;
                        italicCounter = Math.max(italicCounter - 1, 0);
                        break;
                    }
                    case PADDING: {
                        cursorX += Float.parseFloat(token.getData());
                        break;
                    }
                    case ORDERING: {
                        AffineTransform transform;
                        this.tableCellContentStream.beginText();
                        currentFont = paragraph.getFont(boldCounter > 0, italicCounter > 0);
                        this.tableCellContentStream.setFont(currentFont, this.getFontSize());
                        if (this.isTextRotated()) {
                            if (!onlyCalculateHeight) {
                                transform = AffineTransform.getTranslateInstance(cursorX, cursorY);
                                transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
                                transform.concatenate(AffineTransform.getTranslateInstance(-cursorX, -cursorY));
                                this.tableCellContentStream.setTextMatrix(new Matrix(transform));
                                this.tableCellContentStream.newLineAtOffset(cursorX, cursorY);
                                this.tableCellContentStream.showText(token.getData());
                            }
                            cursorY += currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize();
                        } else {
                            if (!onlyCalculateHeight) {
                                this.tableCellContentStream.newLineAtOffset(cursorX, cursorY);
                                this.tableCellContentStream.showText(token.getData());
                            }
                            cursorX += currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize();
                        }
                        this.tableCellContentStream.endText();
                        this.tableCellContentStream.closePath();
                        break;
                    }
                    case BULLET: {
                        if (this.isTextRotated()) {
                            cursorX += FontUtils.getHeight(currentFont, this.getFontSize()) / 2.0f;
                            if (!onlyCalculateHeight) {
                                PDStreamUtils.rect(this.tableCellContentStream, cursorX, cursorY, currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize(), currentFont.getStringWidth(" ") / 1000.0f * this.getFontSize(), this.getTextColor());
                            }
                            cursorY += 2.0f * currentFont.getStringWidth(" ") / 1000.0f * this.getFontSize();
                            cursorX -= FontUtils.getHeight(currentFont, this.getFontSize()) / 2.0f;
                            break;
                        }
                        cursorY += FontUtils.getHeight(currentFont, this.getFontSize()) / 2.0f;
                        if (!onlyCalculateHeight) {
                            PDStreamUtils.rect(this.tableCellContentStream, cursorX, cursorY, currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize(), currentFont.getStringWidth(" ") / 1000.0f * this.getFontSize(), this.getTextColor());
                        }
                        cursorX += 2.0f * currentFont.getStringWidth(" ") / 1000.0f * this.getFontSize();
                        cursorY -= FontUtils.getHeight(currentFont, this.getFontSize()) / 2.0f;
                        break;
                    }
                    case TEXT: {
                        AffineTransform transform;
                        currentFont = paragraph.getFont(boldCounter > 0, italicCounter > 0);
                        this.tableCellContentStream.setFont(currentFont, this.getFontSize());
                        if (this.isTextRotated()) {
                            if (!onlyCalculateHeight) {
                                this.tableCellContentStream.beginText();
                                transform = AffineTransform.getTranslateInstance(cursorX, cursorY);
                                transform.concatenate(AffineTransform.getRotateInstance(1.5707963267948966));
                                transform.concatenate(AffineTransform.getTranslateInstance(-cursorX, -cursorY));
                                this.tableCellContentStream.setTextMatrix(new Matrix(transform));
                                this.tableCellContentStream.newLineAtOffset(cursorX, cursorY);
                                this.tableCellContentStream.showText(token.getData());
                                this.tableCellContentStream.endText();
                                this.tableCellContentStream.closePath();
                            }
                            cursorY += currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize();
                            break;
                        }
                        if (!onlyCalculateHeight) {
                            this.tableCellContentStream.beginText();
                            this.tableCellContentStream.newLineAtOffset(cursorX, cursorY);
                            this.tableCellContentStream.showText(token.getData());
                            this.tableCellContentStream.endText();
                            this.tableCellContentStream.closePath();
                        }
                        cursorX += currentFont.getStringWidth(token.getData()) / 1000.0f * this.getFontSize();
                    }
                }
            }
            cursorX = this.xStart;
            cursorY -= FontUtils.getHeight(this.getFont(), this.getFontSize());
        }
        return cursorY;
    }

    public void draw(PDPage page) {
        try {
            float tableWidth = this.width - this.getLeftPadding() - this.getRightPadding();
            this.tableCellContentStream = new PDPageContentStream(this.doc, page, true, true);
            String[] outerTableText = this.tableData.split("<table");
            for (int i = 1; i < outerTableText.length; ++i) {
                outerTableText[i] = "<table " + outerTableText[i];
            }
            Paragraph outerTextParagraph = null;
            String caption = "";
            this.height = 0.0f;
            this.height = (this.getTopBorder() == null ? 0.0f : this.getTopBorder().getWidth()) + this.getTopPadding();
            for (String element : outerTableText) {
                if (element.contains("</table")) {
                    String[] chunks;
                    for (String chunkie : chunks = element.split("</table>")) {
                        if (chunkie.contains("<table")) {
                            Document document = Jsoup.parse((String)chunkie);
                            Element captionTag = document.select("caption").first();
                            Paragraph tableTitle = null;
                            if (captionTag != null) {
                                caption = captionTag.text();
                                tableTitle = new Paragraph(caption, this.getFontBold(), this.tableTitleFontSize, tableWidth, HorizontalAlignment.CENTER, null);
                                this.yStart = tableTitle.write(this.tableCellContentStream, this.xStart, this.yStart) - this.marginBetweenElementsY;
                            }
                            this.height += captionTag != null ? tableTitle.getHeight() + this.marginBetweenElementsY : 0.0f;
                            this.createInnerTable(tableWidth, document, page, true);
                            continue;
                        }
                        outerTextParagraph = new Paragraph(chunkie, this.getFont(), 8, (int)tableWidth);
                        outerTextParagraph.getLines();
                        this.height += outerTextParagraph != null ? outerTextParagraph.getHeight() + this.marginBetweenElementsY : 0.0f;
                        this.yStart = this.writeOrCalculateParagraph(outerTextParagraph, false);
                    }
                    continue;
                }
                outerTextParagraph = new Paragraph(element, this.getFont(), 8, (int)tableWidth);
                outerTextParagraph.getLines();
                this.height += outerTextParagraph != null ? outerTextParagraph.getHeight() + this.marginBetweenElementsY : 0.0f;
                this.yStart = this.writeOrCalculateParagraph(outerTextParagraph, false);
            }
            this.tableCellContentStream.close();
        }
        catch (IOException e) {
            logger.warn("Cannot draw table for TableCell! Table data: '{}'" + this.tableData + e);
        }
    }

    public float getXPosition() {
        return this.xStart;
    }

    public void setXPosition(float xStart) {
        this.xStart = xStart;
    }

    public float getYPosition() {
        return this.yStart;
    }

    public void setYPosition(float yStart) {
        this.yStart = yStart;
    }

    @Override
    public float getTextHeight() {
        return this.height;
    }

    @Override
    public float getHorizontalFreeSpace() {
        return this.getInnerWidth() - this.width;
    }

    @Override
    public float getVerticalFreeSpace() {
        return this.getInnerHeight() - this.width;
    }
}

