/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.loader;

import com.github.dozermapper.core.CustomConverter;
import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.ClassMapBuilder;
import com.github.dozermapper.core.classmap.ClassMappings;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.MappingFileData;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.converters.CustomConverterContainer;
import com.github.dozermapper.core.converters.CustomConverterDescription;
import com.github.dozermapper.core.loader.LoadMappingsResult;
import com.github.dozermapper.core.loader.MappingsParser;
import com.github.dozermapper.core.util.MappingUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CustomMappingsLoader {
    private final MappingsParser mappingsParser;
    private final ClassMapBuilder classMapBuilder;
    private final BeanContainer beanContainer;

    public CustomMappingsLoader(MappingsParser mappingsParser, ClassMapBuilder classMapBuilder, BeanContainer beanContainer) {
        this.mappingsParser = mappingsParser;
        this.classMapBuilder = classMapBuilder;
        this.beanContainer = beanContainer;
    }

    public LoadMappingsResult load(List<MappingFileData> mappings) {
        Configuration globalConfiguration = this.findConfiguration(mappings);
        ClassMappings customMappings = new ClassMappings(this.beanContainer);
        for (MappingFileData mappingFileData : mappings) {
            List<ClassMap> list = mappingFileData.getClassMaps();
            ClassMappings customMappingsPrime = this.mappingsParser.processMappings(list, globalConfiguration);
            customMappings.addAll(customMappingsPrime);
        }
        this.classMapBuilder.addDefaultFieldMappings(customMappings, globalConfiguration);
        LinkedHashSet<CustomConverterDescription> customConverterDescriptions = new LinkedHashSet<CustomConverterDescription>();
        if (globalConfiguration.getCustomConverters() != null && globalConfiguration.getCustomConverters().getConverters() != null) {
            for (CustomConverterDescription customConverterDescription : globalConfiguration.getCustomConverters().getConverters()) {
                customConverterDescriptions.add(customConverterDescription);
            }
        }
        for (Map.Entry entry : customMappings.getAll().entrySet()) {
            ClassMap classMap = (ClassMap)entry.getValue();
            if (classMap.getCustomConverters() != null) {
                classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
                continue;
            }
            classMap.setCustomConverters(new CustomConverterContainer());
            classMap.getCustomConverters().setConverters(new ArrayList<CustomConverterDescription>(customConverterDescriptions));
        }
        this.addDefaultCustomConverters(globalConfiguration);
        return new LoadMappingsResult(customMappings, globalConfiguration);
    }

    private Configuration findConfiguration(List<MappingFileData> mappingFileDataList) {
        Configuration globalConfiguration = null;
        for (MappingFileData mappingFileData : mappingFileDataList) {
            if (mappingFileData.getConfiguration() == null) continue;
            if (globalConfiguration != null) {
                MappingUtils.throwMappingException("More than one global configuration found.  Only one global configuration block (<configuration></configuration>) can be specified across all mapping files.  You need to consolidate all global configuration blocks into a single one.");
            }
            globalConfiguration = mappingFileData.getConfiguration();
        }
        if (globalConfiguration == null) {
            globalConfiguration = new Configuration();
        }
        return globalConfiguration;
    }

    private void addDefaultCustomConverters(Configuration globalConfiguration) {
        if (globalConfiguration.getCustomConverters() != null && globalConfiguration.getCustomConverters().findConverter(UUID.class, UUID.class) == null) {
            CustomConverterDescription defaultUUIDConverter = new CustomConverterDescription();
            defaultUUIDConverter.setClassA(UUID.class);
            defaultUUIDConverter.setClassB(UUID.class);
            defaultUUIDConverter.setType(ByReferenceConverter.class);
            globalConfiguration.getCustomConverters().addConverter(defaultUUIDConverter);
        }
    }

    public static class ByReferenceConverter
    implements CustomConverter {
        @Override
        public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
            return sourceFieldValue;
        }
    }
}

