/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.paukov.combinatorics3.SimplePermutationGenerator;

class DuplicatedPermutationIterator<T>
implements Iterator<List<T>> {
    private final int length;
    private final int[] data;
    private final List<T> initialOrderedPermutation;
    private List<T> currentPermutation;
    private long currentIndex;
    private boolean isFirstIteration = true;

    DuplicatedPermutationIterator(SimplePermutationGenerator<T> generator) {
        this.length = generator.originalVector.size();
        this.data = new int[this.length];
        List originalVector = generator.originalVector;
        LinkedHashSet initialSet = new LinkedHashSet(originalVector);
        this.initialOrderedPermutation = new ArrayList(initialSet);
        ArrayList<T> initialPermutation = new ArrayList<T>();
        int dataValue = 0;
        int dataIndex = 0;
        for (T value : this.initialOrderedPermutation) {
            ++dataValue;
            if (initialPermutation.contains(value)) continue;
            int count = DuplicatedPermutationIterator.intCountElements(originalVector, value);
            for (int countIndex = 0; countIndex < count; ++countIndex) {
                this.data[dataIndex++] = dataValue;
                initialPermutation.add(value);
            }
        }
        this.currentIndex = 0L;
        this.currentPermutation = new ArrayList<T>();
        for (int i = 0; i < this.length; ++i) {
            this.currentPermutation.add(this.initialOrderedPermutation.get(this.data[i] - 1));
        }
    }

    private static void swap(int[] data, int k, int l) {
        int temp = data[k];
        data[k] = data[l];
        data[l] = temp;
    }

    private static <T> int intCountElements(List<T> list, T value) {
        return Math.toIntExact(list.stream().filter(item -> item.equals(value)).count());
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished() || this.isFirstIteration;
    }

    @Override
    public List<T> next() {
        int i;
        if (this.isFirstIteration) {
            this.isFirstIteration = false;
            return this.currentPermutation;
        }
        int k = this.data.length - 2;
        while (this.data[k] >= this.data[k + 1]) {
            --k;
        }
        int l = this.data.length - 1;
        while (this.data[k] >= this.data[l]) {
            --l;
        }
        DuplicatedPermutationIterator.swap(this.data, k, l);
        int newLength = this.data.length - (k + 1);
        for (i = 0; i < newLength / 2; ++i) {
            DuplicatedPermutationIterator.swap(this.data, k + 1 + i, this.data.length - i - 1);
        }
        ++this.currentIndex;
        this.currentPermutation = new ArrayList<T>();
        for (i = 0; i < this.length; ++i) {
            this.currentPermutation.add(this.initialOrderedPermutation.get(this.data[i] - 1));
        }
        return this.currentPermutation;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "DuplicatedPermutationIterator=[#" + (this.currentIndex + 1L) + ", " + this.currentPermutation + "]";
    }

    private boolean isFinished() {
        int index = this.data.length - 2;
        while (this.data[index] >= this.data[index + 1]) {
            if (--index >= 0) continue;
            return true;
        }
        return false;
    }
}

