/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimplePermutationGenerator;

class SimplePermutationIterator<T>
implements Iterator<List<T>> {
    private final SimplePermutationGenerator<T> generator;
    private final List<T> currentPermutation;
    private final int length;
    private long currentIndex;
    private final int[] array1;
    private final int[] array2;
    private final int[] array3;
    private int positionIndex;

    SimplePermutationIterator(SimplePermutationGenerator<T> generator) {
        this.generator = generator;
        this.length = generator.originalVector.size();
        this.currentPermutation = new ArrayList(generator.originalVector);
        this.array1 = new int[this.length + 2];
        this.array2 = new int[this.length + 2];
        this.array3 = new int[this.length + 2];
        this.currentIndex = 0L;
        for (int i = 1; i <= this.length; ++i) {
            this.array2[i] = i;
            this.array1[i] = i;
            this.array3[i] = -1;
        }
        this.array3[1] = 0;
        this.array1[this.length + 1] = this.positionIndex = this.length + 1;
        this.array1[0] = this.array1[this.length + 1];
    }

    @Override
    public boolean hasNext() {
        return this.positionIndex != 1;
    }

    @Override
    public List<T> next() {
        for (int i = 1; i <= this.length; ++i) {
            int index = this.array1[i] - 1;
            this.currentPermutation.set(i - 1, this.generator.originalVector.get(index));
        }
        this.positionIndex = this.length;
        while (this.array1[this.array2[this.positionIndex] + this.array3[this.positionIndex]] > this.positionIndex) {
            this.array3[this.positionIndex] = -this.array3[this.positionIndex];
            --this.positionIndex;
        }
        int array2value = this.array2[this.positionIndex];
        int array3value = array2value + this.array3[this.positionIndex];
        int array1value = this.array1[array2value];
        this.array1[array2value] = this.array1[array3value];
        this.array1[array3value] = array1value;
        int tmp = this.array1[array2value];
        array1value = this.array2[tmp];
        this.array2[tmp] = array2value;
        this.array2[this.positionIndex] = array1value;
        ++this.currentIndex;
        return new ArrayList<T>(this.currentPermutation);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimplePermutationIterator=[#" + this.currentIndex + ", " + this.currentPermutation + "]";
    }
}

