/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimpleSubSetGenerator;

class SimpleSubSetIterator<T>
implements Iterator<List<T>> {
    private final SimpleSubSetGenerator<T> generator;
    private final int length;
    private final List<T> currentSubSet;
    private long currentIndex;
    private final BitSet bitVector;

    SimpleSubSetIterator(SimpleSubSetGenerator<T> generator) {
        this.generator = generator;
        this.length = generator.originalVector.size();
        this.currentSubSet = new ArrayList<T>(this.length);
        this.bitVector = new BitSet(this.length + 2);
        this.currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return !this.bitVector.get(this.length + 1);
    }

    @Override
    public List<T> next() {
        ++this.currentIndex;
        List originalVector = this.generator.originalVector;
        BitSet bitVector = this.bitVector;
        int subSetSize = this.currentSubSet.size();
        int j = 0;
        int i = bitVector.nextSetBit(1);
        while (i >= 0) {
            Object e = originalVector.get(i - 1);
            if (j < subSetSize) {
                this.currentSubSet.set(j++, e);
            } else {
                this.currentSubSet.add(e);
            }
            i = bitVector.nextSetBit(i + 1);
        }
        if (j < subSetSize) {
            this.currentSubSet.subList(j, subSetSize).clear();
        }
        i = 1;
        while (bitVector.get(i)) {
            bitVector.clear(i);
            ++i;
        }
        bitVector.set(i);
        return new ArrayList<T>(this.currentSubSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimpleSubSetIterator=[#" + this.currentIndex + ", " + this.currentSubSet + "]";
    }
}

