/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NodeAndNPMInstaller;
import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultNodeAndNPMInstaller
implements NodeAndNPMInstaller {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    DefaultNodeAndNPMInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    @Override
    public void install(String nodeVersion, String npmVersion, String nodeDownloadRoot, String npmDownloadRoot) throws InstallationException {
        if (nodeDownloadRoot == null || nodeDownloadRoot.isEmpty()) {
            nodeDownloadRoot = "http://nodejs.org/dist/";
        }
        if (npmDownloadRoot == null || npmDownloadRoot.isEmpty()) {
            npmDownloadRoot = "http://registry.npmjs.org/npm/-/";
        }
        new NodeAndNPMInstallAction(nodeVersion, npmVersion, nodeDownloadRoot, npmDownloadRoot).install();
    }

    private final class NodeAndNPMInstallAction {
        private static final String VERSION = "version";
        private final String nodeVersion;
        private final String npmVersion;
        private final String nodeDownloadRoot;
        private final String npmDownloadRoot;

        public NodeAndNPMInstallAction(String nodeVersion, String npmVersion, String nodeDownloadRoot, String npmDownloadRoot) {
            this.nodeVersion = nodeVersion;
            this.npmVersion = npmVersion;
            this.nodeDownloadRoot = nodeDownloadRoot;
            this.npmDownloadRoot = npmDownloadRoot;
        }

        public void install() throws InstallationException {
            if (!this.nodeIsAlreadyInstalled()) {
                if (DefaultNodeAndNPMInstaller.this.config.getPlatform().isWindows()) {
                    this.installNodeForWindows();
                } else {
                    this.installNodeDefault();
                }
            }
            if (!this.npmIsAlreadyInstalled()) {
                this.installNpm();
            }
        }

        private boolean nodeIsAlreadyInstalled() {
            try {
                InstallNodeExecutorConfig executorConfig = new InstallNodeExecutorConfig(DefaultNodeAndNPMInstaller.this.config);
                File nodeFile = executorConfig.getNodePath();
                if (nodeFile.exists()) {
                    String version = new NodeExecutor(executorConfig, Arrays.asList("--version")).executeAndGetResult();
                    if (version.equals(this.nodeVersion)) {
                        DefaultNodeAndNPMInstaller.this.logger.info("Node " + version + " is already installed.");
                        return true;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Node " + version + " was installed, but we need version " + this.nodeVersion);
                    return false;
                }
                return false;
            }
            catch (ProcessExecutionException e) {
                return false;
            }
        }

        private boolean npmIsAlreadyInstalled() {
            try {
                File npmPackageJson = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + Utils.normalize("/node/node_modules/npm/package.json"));
                if (npmPackageJson.exists()) {
                    HashMap data = (HashMap)new ObjectMapper().readValue(npmPackageJson, HashMap.class);
                    if (data.containsKey(VERSION)) {
                        String foundNpmVersion = data.get(VERSION).toString();
                        DefaultNodeAndNPMInstaller.this.logger.info("Found NPM version " + foundNpmVersion);
                        if (foundNpmVersion.equals(this.npmVersion)) {
                            return true;
                        }
                        DefaultNodeAndNPMInstaller.this.logger.info("Mismatch between found NPM version and required NPM version");
                        return false;
                    }
                    DefaultNodeAndNPMInstaller.this.logger.info("Could not read NPM version from package.json");
                    return false;
                }
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not read package.json", ex);
            }
        }

        private void installNpm() throws InstallationException {
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing npm version " + this.npmVersion);
                String downloadUrl = this.npmDownloadRoot + "npm-" + this.npmVersion + ".tgz";
                String targetName = DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + File.separator + "npm.tar.gz";
                DefaultNodeAndNPMInstaller.this.logger.info("Downloading NPM from " + downloadUrl + " to " + targetName);
                this.downloadFile(downloadUrl, targetName);
                File oldNpmDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory(), "./node/npm");
                File npmDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory(), "./node/node_modules/npm");
                try {
                    if (oldNpmDirectory.isDirectory()) {
                        FileUtils.deleteDirectory((File)oldNpmDirectory);
                    }
                    FileUtils.deleteDirectory((File)npmDirectory);
                }
                catch (IOException e) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Failed to delete existing NPM installation.");
                }
                DefaultNodeAndNPMInstaller.this.logger.info("Extracting NPM files in node/");
                this.extractFile(targetName, DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "/node/node_modules");
                new File(targetName).delete();
                File packageDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory(), "./node/node_modules/package");
                if (packageDirectory.exists() && !npmDirectory.exists() && !packageDirectory.renameTo(npmDirectory)) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Cannot rename NPM directory, making a copy.");
                    FileUtils.copyDirectory((File)packageDirectory, (File)npmDirectory);
                }
                for (String script : Arrays.asList("npm", "npm.cmd")) {
                    File scriptFile = new File(npmDirectory, "bin/" + script);
                    if (!scriptFile.exists()) continue;
                    File copy = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory(), "/node/" + script);
                    FileUtils.copyFile((File)scriptFile, (File)copy);
                    copy.setExecutable(true);
                }
                DefaultNodeAndNPMInstaller.this.logger.info("Installed NPM locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download npm", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the npm archive", e);
            }
            catch (IOException e) {
                throw new InstallationException("Could not copy npm", e);
            }
        }

        private void installNodeDefault() throws InstallationException {
            String downloadUrl = "";
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing node version " + this.nodeVersion);
                if (!this.nodeVersion.startsWith("v")) {
                    DefaultNodeAndNPMInstaller.this.logger.warn("Node version does not start with naming convention 'v'.");
                }
                String longNodeFilename = DefaultNodeAndNPMInstaller.this.config.getPlatform().getLongNodeFilename(this.nodeVersion);
                downloadUrl = this.nodeDownloadRoot + DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeDownloadFilename(this.nodeVersion);
                File tmpDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + File.separator + "node_tmp");
                DefaultNodeAndNPMInstaller.this.logger.info("Creating temporary directory " + tmpDirectory);
                tmpDirectory.mkdirs();
                String targetName = DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "/node_tmp/node.tar.gz";
                DefaultNodeAndNPMInstaller.this.logger.info("Downloading Node.js from " + downloadUrl + " to " + targetName);
                this.downloadFile(downloadUrl, targetName);
                DefaultNodeAndNPMInstaller.this.logger.info("Extracting Node.js files in node_tmp");
                this.extractFile(targetName, DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "/node_tmp");
                File nodeBinary = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "/node_tmp/" + longNodeFilename + "/bin/node");
                if (!nodeBinary.exists()) {
                    throw new FileNotFoundException("Could not find the downloaded Node.js binary in " + nodeBinary);
                }
                File destinationDirectory = new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "/node");
                destinationDirectory.mkdirs();
                File destination = new File(destinationDirectory + "/node");
                DefaultNodeAndNPMInstaller.this.logger.info("Moving node binary to " + destination);
                if (!nodeBinary.renameTo(destination)) {
                    throw new InstallationException("Could not install Node: Was not allowed to rename " + nodeBinary + " to " + destination);
                }
                if (!destination.setExecutable(true, false)) {
                    throw new InstallationException("Cound not install Node: Was not allowed to make " + destination + " executable.");
                }
                DefaultNodeAndNPMInstaller.this.logger.info("Deleting temporary directory " + tmpDirectory);
                FileUtils.deleteDirectory((File)tmpDirectory);
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node locally.");
            }
            catch (IOException e) {
                throw new InstallationException("Could not install Node", e);
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js", e);
            }
            catch (ArchiveExtractionException e) {
                throw new InstallationException("Could not extract the Node archive", e);
            }
        }

        private void installNodeForWindows() throws InstallationException {
            String downloadUrl = this.nodeDownloadRoot + DefaultNodeAndNPMInstaller.this.config.getPlatform().getNodeDownloadFilename(this.nodeVersion);
            try {
                DefaultNodeAndNPMInstaller.this.logger.info("Installing node version " + this.nodeVersion);
                new File(DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "\\node").mkdirs();
                this.downloadFile(downloadUrl, DefaultNodeAndNPMInstaller.this.config.getInstallDirectory() + "\\node\\node.exe");
                DefaultNodeAndNPMInstaller.this.logger.info("Installed node.exe locally.");
            }
            catch (DownloadException e) {
                throw new InstallationException("Could not download Node.js from: " + downloadUrl, e);
            }
        }

        private void extractFile(String archive, String destinationDirectory) throws ArchiveExtractionException {
            DefaultNodeAndNPMInstaller.this.logger.info("Unpacking " + archive + " into " + destinationDirectory);
            DefaultNodeAndNPMInstaller.this.archiveExtractor.extract(archive, destinationDirectory);
        }

        private void downloadFile(String downloadUrl, String destination) throws DownloadException {
            DefaultNodeAndNPMInstaller.this.fileDownloader.download(downloadUrl, destination);
        }
    }
}

