/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonArray;
import com.github.erosb.jsonsKema.IJsonBoolean;
import com.github.erosb.jsonsKema.IJsonNull;
import com.github.erosb.jsonsKema.IJsonNumber;
import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/erosb/jsonsKema/JsonPrintingVisitor;", "Lcom/github/erosb/jsonsKema/JsonVisitor;", "", "indentation", "(Ljava/lang/String;)V", "indentLevel", "", "visitArray", "arr", "Lcom/github/erosb/jsonsKema/IJsonArray;", "visitBoolean", "bool", "Lcom/github/erosb/jsonsKema/IJsonBoolean;", "visitNull", "nil", "Lcom/github/erosb/jsonsKema/IJsonNull;", "visitNumber", "num", "Lcom/github/erosb/jsonsKema/IJsonNumber;", "visitObject", "obj", "Lcom/github/erosb/jsonsKema/IJsonObject;", "visitString", "str", "Lcom/github/erosb/jsonsKema/IJsonString;", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nJsonPrintingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonPrintingVisitor.kt\ncom/github/erosb/jsonsKema/JsonPrintingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,45:1\n1549#2:46\n1620#2,3:47\n125#3:50\n152#3,3:51\n*S KotlinDebug\n*F\n+ 1 JsonPrintingVisitor.kt\ncom/github/erosb/jsonsKema/JsonPrintingVisitor\n*L\n20#1:46\n20#1:47,3\n35#1:50\n35#1:51,3\n*E\n"})
public final class JsonPrintingVisitor
implements JsonVisitor<String> {
    @NotNull
    private final String indentation;
    private int indentLevel;

    public JsonPrintingVisitor(@NotNull String indentation) {
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        this.indentation = indentation;
    }

    public /* synthetic */ JsonPrintingVisitor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "  ";
        }
        this(string);
    }

    @Override
    @NotNull
    public String visitString(@NotNull IJsonString str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        char c = '\"';
        String string = str.getValue();
        return c + string + '\"';
    }

    @Override
    @NotNull
    public String visitBoolean(@NotNull IJsonBoolean bool) {
        Intrinsics.checkNotNullParameter((Object)bool, (String)"bool");
        return String.valueOf(bool.getValue());
    }

    @Override
    @NotNull
    public String visitNumber(@NotNull IJsonNumber num) {
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        return num.getValue().toString();
    }

    @Override
    @NotNull
    public String visitNull(@NotNull IJsonNull nil) {
        Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
        return "null";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String visitArray(@NotNull IJsonArray<?> arr) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        String baseIndent = StringsKt.repeat((CharSequence)this.indentation, (int)this.indentLevel);
        String nestedIndent = baseIndent + this.indentation;
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        Object object = arr.getElements();
        boolean $i$f$map = false;
        String string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void el;
            IJsonValue iJsonValue = (IJsonValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)el.accept(this));
        }
        List list = (List)destination$iv$iv;
        object = "[\n" + nestedIndent;
        String string2 = ",\n" + nestedIndent;
        string = '\n' + baseIndent + ']';
        String rval = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)string2, (CharSequence)((CharSequence)object), (CharSequence)string, (int)0, null, null, (int)56, null);
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
        return rval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String visitObject(@NotNull IJsonObject<?, ?> obj) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        String baseIndent = StringsKt.repeat((CharSequence)this.indentation, (int)this.indentLevel);
        String nestedIndent = baseIndent + this.indentation;
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        Object object = obj.getProperties();
        boolean $i$f$map = false;
        String string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)((IJsonString)entry.getKey()).accept(this) + ": " + (String)((IJsonValue)entry.getValue()).accept(this));
        }
        List list = (List)destination$iv$iv;
        object = "{\n" + nestedIndent;
        String string2 = ",\n" + nestedIndent;
        string = '\n' + baseIndent + '}';
        String rval = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)string2, (CharSequence)((CharSequence)object), (CharSequence)string, (int)0, null, null, (int)56, null);
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
        return rval;
    }

    @Override
    @Nullable
    public String identity() {
        return JsonVisitor.DefaultImpls.identity(this);
    }

    @Override
    @Nullable
    public String accumulate(@Nullable String previous, @Nullable String current) {
        return JsonVisitor.DefaultImpls.accumulate(this, previous, current);
    }

    public JsonPrintingVisitor() {
        this(null, 1, null);
    }
}

