/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.core;

import com.eugenenosenko.conventional.changelog.core.ICommitBody;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

final class CommitBody
implements ICommitBody {
    private final Predicate<String> breakingChangePredicate = CommitBody::doesContainBreakingChange;
    public static final CommitBody EMPTY = new CommitBody(new String[0]);
    private final boolean isBreakingChange;
    private final List<String> body;

    public CommitBody(String[] rawBody) {
        this.body = Arrays.asList((Object[])rawBody);
        this.isBreakingChange = this.body.stream().anyMatch(this.breakingChangePredicate);
    }

    @Override
    public boolean isBreakingChange() {
        return this.isBreakingChange;
    }

    @Override
    public String getBreakingChangeDescription() {
        return this.getBody();
    }

    @Override
    public String getBody() {
        return this.isBreakingChange ? this.getBreakingChangeText() : "";
    }

    private static boolean doesContainBreakingChange(String string) {
        return string.contains("BREAKING-CHANGE:") || string.contains("BREAKING CHANGE");
    }

    private String getBreakingChangeText() {
        for (String line : this.body) {
            if (!this.breakingChangePredicate.test(line)) continue;
            return line;
        }
        return "";
    }
}

