/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.core;

import com.eugenenosenko.conventional.changelog.core.CommitType;
import com.eugenenosenko.conventional.changelog.core.ICommitMessage;
import com.eugenenosenko.conventional.changelog.util.CommitMatcherUtil;
import com.eugenenosenko.conventional.changelog.util.StringUtil;
import java.util.regex.Matcher;

final class CommitMessage
implements ICommitMessage {
    private final String rawMessage;
    private final CommitType type;
    private final String message;
    private final String scope;
    private final boolean isBreakingChange;

    CommitMessage(String rawMessage) {
        this.rawMessage = rawMessage.trim();
        ConventionalCommitMatcher matcher = new ConventionalCommitMatcher(this.rawMessage);
        this.type = matcher.getType();
        this.message = matcher.getMessage();
        this.scope = matcher.getScope();
        this.isBreakingChange = matcher.isBreakingChange();
    }

    @Override
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public CommitType getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public boolean isBreakingChange() {
        return this.isBreakingChange;
    }

    @Override
    public String getBreakingChangeDescription() {
        return this.isBreakingChange ? this.message : "";
    }

    private static class ConventionalCommitMatcher {
        private final Matcher matcher;

        public ConventionalCommitMatcher(String rawString) {
            this.matcher = CommitMatcherUtil.COMMIT_MESSAGE_REGEX.matcher(rawString);
            this.matcher.find();
        }

        CommitType getType() {
            return CommitType.of(this.matcher.group(1));
        }

        String getScope() {
            return StringUtil.getNullable(this.matcher.group(2));
        }

        boolean isBreakingChange() {
            return this.matcher.group(3) != null;
        }

        String getMessage() {
            return StringUtil.getNullable(this.matcher.group(4));
        }
    }
}

