/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.core;

import com.eugenenosenko.conventional.changelog.core.BreakingChangeItem;
import com.eugenenosenko.conventional.changelog.core.CommitBody;
import com.eugenenosenko.conventional.changelog.core.CommitFooter;
import com.eugenenosenko.conventional.changelog.core.CommitMessage;
import com.eugenenosenko.conventional.changelog.core.CommitType;
import com.eugenenosenko.conventional.changelog.core.ICommitBody;
import com.eugenenosenko.conventional.changelog.core.ICommitFooter;
import com.eugenenosenko.conventional.changelog.core.ICommitMessage;
import java.util.stream.Stream;

public final class ConventionalCommit
implements ICommitBody,
ICommitFooter,
ICommitMessage {
    private final CommitMessage commitMessage;
    private final CommitBody commitBody;
    private final CommitFooter commitFooter;

    public ConventionalCommit(CommitMessage commitMessage, CommitBody commitBody, CommitFooter commitFooter) {
        this.commitMessage = commitMessage;
        this.commitBody = commitBody;
        this.commitFooter = commitFooter;
    }

    public ConventionalCommit(CommitMessage commitMessage) {
        this(commitMessage, CommitBody.EMPTY, CommitFooter.EMPTY);
    }

    public ConventionalCommit(CommitMessage commitMessage, CommitFooter commitFooter) {
        this(commitMessage, CommitBody.EMPTY, commitFooter);
    }

    @Override
    public String getFooter() {
        return this.commitFooter.getFooter();
    }

    @Override
    public String getBody() {
        return this.commitBody.getBody();
    }

    @Override
    public String getRawMessage() {
        return this.commitMessage.getRawMessage();
    }

    @Override
    public CommitType getType() {
        return this.commitMessage.getType();
    }

    public String getDecoratedScope() {
        return "**" + this.getScope() + "**";
    }

    @Override
    public String getMessage() {
        return this.commitMessage.getMessage();
    }

    @Override
    public String getScope() {
        return this.commitMessage.getScope();
    }

    @Override
    public boolean isBreakingChange() {
        return this.commitMessage.isBreakingChange() || this.commitBody.isBreakingChange() || this.commitFooter.isBreakingChange();
    }

    @Override
    public String getBreakingChangeDescription() {
        return Stream.of(this.commitFooter, this.commitBody, this.commitMessage).filter(BreakingChangeItem::isBreakingChange).map(BreakingChangeItem::getBreakingChangeDescription).map(string -> string.replace("BREAKING-CHANGE: ", "")).map(string -> string.replace("BREAKING CHANGE: ", "")).findFirst().orElse("");
    }
}

