/*
 * Decompiled with CFR 0.152.
 */
package com.eugenenosenko.conventional.changelog.plugin.parser;

import com.eugenenosenko.conventional.changelog.core.entry.ReleaseEntry;
import com.eugenenosenko.conventional.changelog.plugin.backup.Undoable;
import com.eugenenosenko.conventional.changelog.plugin.context.VersionTag;
import com.eugenenosenko.conventional.changelog.plugin.file.FirstParagraphTransformer;
import com.eugenenosenko.conventional.changelog.plugin.file.LogFileHandler;
import com.eugenenosenko.conventional.changelog.plugin.git.GitService;
import com.eugenenosenko.conventional.changelog.plugin.parser.FromLastTagParser;
import com.eugenenosenko.conventional.changelog.plugin.parser.FullHistoryParser;
import com.eugenenosenko.conventional.changelog.plugin.parser.NTagsParser;
import com.eugenenosenko.conventional.changelog.plugin.parser.TagParser;
import com.eugenenosenko.conventional.changelog.plugin.version.LastVersionResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChangelogManager
implements AutoCloseable,
Undoable,
TagParser {
    private static final Logger log = LoggerFactory.getLogger(ChangelogManager.class);
    private final LogFileHandler changelogHandler;
    private final LogFileHandler backupHandler;
    private final GitService gitService;
    private boolean backupMade = false;

    public ChangelogManager(GitService gitService, LogFileHandler changeLogHandler, LogFileHandler backupLogHandler) {
        this.gitService = gitService;
        this.changelogHandler = changeLogHandler;
        this.backupHandler = backupLogHandler;
    }

    @Override
    public void close() throws Exception {
        this.backupHandler.deleteFile();
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException("Undo not supported at this point");
    }

    @Override
    public Map<VersionTag, List<RevCommit>> parse(int releaseCount) throws GitAPIException, IOException {
        if (this.changelogHandler.isFileEmpty() && releaseCount == -1) {
            log.info("Couldn't find {} . Will try to create one", (Object)this.changelogHandler.getFile());
            return new FullHistoryParser().parse(this.gitService);
        }
        if (releaseCount >= 0) {
            log.info("Fetching changelog for last {} releases", (Object)(releaseCount + 1));
            return new NTagsParser(releaseCount).parse(this.gitService);
        }
        String lastRelease = new LastVersionResolver(this.changelogHandler.readFirstLine()).resolve();
        log.info("Changelog file already exists. Last recorded release: {}", (Object)lastRelease);
        Map<VersionTag, List<RevCommit>> parse = new FromLastTagParser(lastRelease).parse(this.gitService);
        log.info("Copying previous changelog file contents to a backup file.");
        this.makeACopyOfChangelog();
        this.changelogHandler.clearFileContents();
        this.backupMade = true;
        return parse;
    }

    private void makeACopyOfChangelog() throws IOException {
        if (!this.backupHandler.exists()) {
            Files.createFile(this.backupHandler.getFile(), new FileAttribute[0]);
        }
        this.backupHandler.writeFrom(this.changelogHandler.getFile(), StandardOpenOption.WRITE);
    }

    public void writeEntriesToChangelog(List<ReleaseEntry> entries) throws IOException {
        if (!this.changelogHandler.exists()) {
            Files.createFile(this.changelogHandler.getFile(), new FileAttribute[0]);
        }
        for (ReleaseEntry entry : entries) {
            this.changelogHandler.appendStringToFile(entry.toString().concat("\n"));
        }
        if (this.backupMade) {
            Path backFile = this.backupHandler.getFile();
            this.changelogHandler.writeFrom(backFile, StandardOpenOption.APPEND, new FirstParagraphTransformer());
        }
    }
}

