/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import java.time.Clock;
import java.util.SplittableRandom;

public final class DefaultTimeFunction
implements TimeFunction {
    private final Clock clock;
    private long lastTime = -1L;
    private long counter = Math.abs(new SplittableRandom().nextLong()) % 10000L;
    private long counterMax = this.counter + 10000L;

    public DefaultTimeFunction() {
        this.clock = Clock.systemUTC();
    }

    public DefaultTimeFunction(Clock clock) {
        this.clock = clock;
    }

    @Override
    public long getAsLong() {
        ++this.counter;
        long time = this.clock.millis();
        if (time == this.lastTime) {
            if (this.counter >= this.counterMax) {
                while (time == this.lastTime) {
                    time = this.clock.millis();
                }
                this.counter %= 10000L;
                this.counterMax = this.counter + 10000L;
            }
        } else {
            this.counter %= 10000L;
            this.counterMax = this.counter + 10000L;
        }
        this.lastTime = time;
        return time * 10000L + this.counter;
    }
}

