/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;
import java.util.function.LongSupplier;

public final class ShortSuffixCombFactory
extends AbstCombFactory {
    protected final int interval;
    protected static final int DEFAULT_INTERVAL = 60000;

    public ShortSuffixCombFactory() {
        this(ShortSuffixCombFactory.builder());
    }

    public ShortSuffixCombFactory(Clock clock) {
        this((Builder)ShortSuffixCombFactory.builder().withClock(clock));
    }

    public ShortSuffixCombFactory(Random random) {
        this((Builder)ShortSuffixCombFactory.builder().withRandom(random));
    }

    public ShortSuffixCombFactory(Random random, Clock clock) {
        this((Builder)((Builder)ShortSuffixCombFactory.builder().withRandom(random)).withClock(clock));
    }

    public ShortSuffixCombFactory(LongSupplier randomFunction) {
        this((Builder)ShortSuffixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public ShortSuffixCombFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)ShortSuffixCombFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    private ShortSuffixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
        this.interval = builder.getInterval();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID create() {
        this.lock.lock();
        try {
            long time = this.timeFunction.getAsLong() / (long)this.interval;
            if (this.random instanceof AbstRandomBasedFactory.SafeRandom) {
                byte[] bytes = this.random.nextBytes(14);
                long long1 = ByteUtil.toNumber(bytes, 0, 8);
                long long2 = ByteUtil.toNumber(bytes, 8, 14);
                UUID uUID = this.make(time, long1, long2);
                return uUID;
            }
            long long1 = this.random.nextLong();
            long long2 = this.random.nextLong();
            UUID uUID = this.make(time, long1, long2);
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(long1, (long2 & 0xFFFF00000000L) << 16 | (time & 0xFFFFL) << 32 | long2 & 0xFFFFFFFFL);
    }

    public static class Builder
    extends AbstCombFactory.Builder<ShortSuffixCombFactory, Builder> {
        private Integer interval;

        protected int getInterval() {
            if (this.interval == null) {
                this.interval = 60000;
            }
            return this.interval;
        }

        public Builder withInterval(int interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public ShortSuffixCombFactory build() {
            return new ShortSuffixCombFactory(this);
        }
    }
}

