/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.Artifact;

public final class DependencyNode {
    private final org.apache.maven.artifact.Artifact artifact;
    private final String effectiveVersion;
    private final NodeResolution resolution;
    private final Set<String> scopes;
    private final Set<String> classifiers;
    private final Set<String> types;

    public DependencyNode(org.apache.maven.artifact.Artifact artifact) {
        this(artifact, DependencyNode.determineNodeResolution(artifact), artifact.getVersion());
    }

    public DependencyNode(org.eclipse.aether.graph.DependencyNode dependencyNode) {
        this(DependencyNode.createMavenArtifact(dependencyNode), DependencyNode.determineResolution(dependencyNode), DependencyNode.determineEffectiveVersion(dependencyNode));
    }

    private DependencyNode(org.apache.maven.artifact.Artifact artifact, NodeResolution resolution, String effectiveVersion) {
        if (artifact == null) {
            throw new NullPointerException("Artifact must not be null");
        }
        if (artifact.getScope() == null) {
            artifact.setScope("compile");
        }
        this.effectiveVersion = effectiveVersion;
        this.scopes = new TreeSet<String>();
        this.classifiers = new TreeSet<String>();
        this.types = new TreeSet<String>();
        this.artifact = artifact;
        this.resolution = resolution;
        this.scopes.add(artifact.getScope());
        this.types.add(artifact.getType());
        if (!Strings.isNullOrEmpty((String)artifact.getClassifier())) {
            this.classifiers.add(artifact.getClassifier());
        }
    }

    public void merge(DependencyNode other) {
        if (this == other) {
            return;
        }
        if (this.artifact.isOptional()) {
            this.artifact.setOptional(other.getArtifact().isOptional());
        }
        this.scopes.addAll(other.scopes);
        this.classifiers.addAll(other.classifiers);
        this.types.addAll(other.types);
    }

    public org.apache.maven.artifact.Artifact getArtifact() {
        return this.artifact;
    }

    public NodeResolution getResolution() {
        return this.resolution;
    }

    public Set<String> getScopes() {
        return ImmutableSet.copyOf(this.scopes);
    }

    public Set<String> getClassifiers() {
        return ImmutableSet.copyOf(this.classifiers);
    }

    public Set<String> getTypes() {
        return ImmutableSet.copyOf(this.types);
    }

    public String getEffectiveVersion() {
        return this.effectiveVersion;
    }

    public String getEffectiveScope() {
        if (this.scopes.size() > 0) {
            return this.scopes.iterator().next();
        }
        return null;
    }

    public String toString() {
        return this.artifact.toString();
    }

    private static org.apache.maven.artifact.Artifact createMavenArtifact(org.eclipse.aether.graph.DependencyNode dependencyNode) {
        Artifact artifact = dependencyNode.getArtifact();
        String scope = null;
        boolean optional = false;
        if (dependencyNode.getDependency() != null) {
            scope = dependencyNode.getDependency().getScope();
            optional = dependencyNode.getDependency().isOptional();
        }
        DefaultArtifact mavenArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), scope, artifact.getProperty("type", artifact.getExtension()), artifact.getClassifier(), null);
        mavenArtifact.setOptional(optional);
        return mavenArtifact;
    }

    private static NodeResolution determineResolution(org.eclipse.aether.graph.DependencyNode dependencyNode) {
        org.eclipse.aether.graph.DependencyNode winner = (org.eclipse.aether.graph.DependencyNode)dependencyNode.getData().get("conflict.winner");
        if (winner != null) {
            if (winner.getArtifact().getVersion().equals(dependencyNode.getArtifact().getVersion())) {
                return NodeResolution.OMITTED_FOR_DUPLICATE;
            }
            return NodeResolution.OMITTED_FOR_CONFLICT;
        }
        return NodeResolution.INCLUDED;
    }

    private static NodeResolution determineNodeResolution(org.apache.maven.artifact.Artifact artifact) {
        if (artifact.getScope() == null) {
            return NodeResolution.PARENT;
        }
        return NodeResolution.INCLUDED;
    }

    private static String determineEffectiveVersion(org.eclipse.aether.graph.DependencyNode dependencyNode) {
        org.eclipse.aether.graph.DependencyNode winner = (org.eclipse.aether.graph.DependencyNode)dependencyNode.getData().get("conflict.winner");
        if (winner != null) {
            return winner.getArtifact().getVersion();
        }
        return dependencyNode.getArtifact().getVersion();
    }
}

