/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="ltrim")
class LTrim
extends AbstractRedisOperation {
    LTrim(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        int start = Integer.parseInt(this.params().get(1).toString());
        int end = Integer.parseInt(this.params().get(2).toString());
        RMList listDBObj = this.getListFromBaseOrCreateEmpty(key);
        List<Slice> list = listDBObj.getStoredData();
        int size = list.size();
        start = start < 0 ? size + start : start;
        start = Math.max(start, 0);
        int n = end = end < 0 ? size + end : end;
        if (start > size || start > end || end < 0) {
            list.clear();
        } else {
            end = end >= size ? size : end + 1;
            list.subList(end, list.size()).clear();
            list.subList(0, start).clear();
        }
        return Response.OK;
    }
}

