/*
 * Decompiled with CFR 0.152.
 */
package com.github.freva.asciitable;

import com.github.freva.asciitable.AsciiTableBuilder;
import com.github.freva.asciitable.Column;
import com.github.freva.asciitable.ColumnData;
import com.github.freva.asciitable.HorizontalAlign;
import com.github.freva.asciitable.LineUtils;
import com.github.freva.asciitable.OverflowBehaviour;
import com.github.freva.asciitable.Styler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class AsciiTable {
    private static final int PADDING = 1;
    private static final char ELLIPSIS = '\u2026';
    public static final Character[] NO_BORDERS = new Character[29];
    public static final Character[] BASIC_ASCII = new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+')};
    public static final Character[] BASIC_ASCII_NO_DATA_SEPARATORS = new Character[]{Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), null, null, null, null, Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('|'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('+')};
    public static final Character[] BASIC_ASCII_NO_DATA_SEPARATORS_NO_OUTSIDE_BORDER = new Character[]{null, null, null, null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null};
    public static final Character[] BASIC_ASCII_NO_OUTSIDE_BORDER = new Character[]{null, null, null, null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('-'), Character.valueOf('+'), null, null, Character.valueOf('|'), null, null, null, null, null};
    public static final Character[] FANCY_ASCII = new Character[]{Character.valueOf('\u2554'), Character.valueOf('\u2550'), Character.valueOf('\u2564'), Character.valueOf('\u2557'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u2560'), Character.valueOf('\u2550'), Character.valueOf('\u256a'), Character.valueOf('\u2563'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u255f'), Character.valueOf('\u2500'), Character.valueOf('\u253c'), Character.valueOf('\u2562'), Character.valueOf('\u2560'), Character.valueOf('\u2550'), Character.valueOf('\u256a'), Character.valueOf('\u2563'), Character.valueOf('\u2551'), Character.valueOf('\u2502'), Character.valueOf('\u2551'), Character.valueOf('\u255a'), Character.valueOf('\u2550'), Character.valueOf('\u2567'), Character.valueOf('\u255d')};

    static void writeTable(OutputStreamWriter osw, String lineSeparator, Character[] border, Column[] rawColumns, Object[][] data, Styler styler) throws IOException {
        if (border.length != NO_BORDERS.length) {
            throw new IllegalArgumentException("Border characters array must be exactly " + NO_BORDERS.length + " elements long");
        }
        String[][] stringData = AsciiTable.objectArrayToString(rawColumns, data);
        int numColumns = AsciiTable.getNumColumns(rawColumns, data);
        Column[] columns = (Column[])IntStream.range(0, numColumns).mapToObj(index -> index < rawColumns.length ? rawColumns[index] : new Column()).filter(Column::isVisible).toArray(Column[]::new);
        AsciiTable.writeTable(osw, lineSeparator, border, columns, stringData, styler);
    }

    private static void writeTable(OutputStreamWriter osw, String lineSeparator, Character[] border, Column[] columns, String[][] data, Styler styler) throws IOException {
        int[] colWidths = AsciiTable.getColWidths(columns, data);
        OverflowBehaviour[] overflows = (OverflowBehaviour[])Arrays.stream(columns).map(Column::getOverflowBehaviour).toArray(OverflowBehaviour[]::new);
        boolean insertNewline = AsciiTable.writeLine(osw, colWidths, border[0], border[1], border[2], border[3]);
        if (Arrays.stream(columns).map(Column::getHeader).anyMatch(Objects::nonNull)) {
            HorizontalAlign[] aligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getHeaderAlign).toArray(HorizontalAlign[]::new);
            String[] header = (String[])Arrays.stream(columns).map(Column::getHeader).toArray(String[]::new);
            if (insertNewline) {
                osw.write(lineSeparator);
            }
            AsciiTable.writeData(osw, colWidths, overflows, aligns, header, border[4], border[5], border[6], lineSeparator, styler == null ? null : (col, rows) -> styler.styleHeader(columns[col], (int)col, (List<String>)rows));
            osw.write(lineSeparator);
            insertNewline = AsciiTable.writeLine(osw, colWidths, border[7], border[8], border[9], border[10]);
        }
        HorizontalAlign[] dataAligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getDataAlign).toArray(HorizontalAlign[]::new);
        for (int i = 0; i < data.length; ++i) {
            if (insertNewline) {
                osw.write(lineSeparator);
            }
            int row = i;
            AsciiTable.writeData(osw, colWidths, overflows, dataAligns, data[i], border[11], border[12], border[13], lineSeparator, styler == null ? null : (col, rows) -> styler.styleCell(columns[col], row, (int)col, (List<String>)rows));
            if (i >= data.length - 1) continue;
            osw.write(lineSeparator);
            insertNewline = AsciiTable.writeLine(osw, colWidths, border[14], border[15], border[16], border[17]);
        }
        if (Arrays.stream(columns).map(Column::getFooter).anyMatch(Objects::nonNull)) {
            osw.write(lineSeparator);
            HorizontalAlign[] aligns = (HorizontalAlign[])Arrays.stream(columns).map(Column::getFooterAlign).toArray(HorizontalAlign[]::new);
            String[] footer = (String[])Arrays.stream(columns).map(Column::getFooter).toArray(String[]::new);
            insertNewline = AsciiTable.writeLine(osw, colWidths, border[18], border[19], border[20], border[21]);
            if (insertNewline) {
                osw.write(lineSeparator);
            }
            AsciiTable.writeData(osw, colWidths, overflows, aligns, footer, border[22], border[23], border[24], lineSeparator, styler == null ? null : (col, rows) -> styler.styleFooter(columns[col], (int)col, (List<String>)rows));
        }
        if (border[26] != null) {
            osw.write(lineSeparator);
        }
        AsciiTable.writeLine(osw, colWidths, border[25], border[26], border[27], border[28]);
    }

    private static boolean writeLine(OutputStreamWriter osw, int[] colWidths, Character left, Character middle, Character columnSeparator, Character right) throws IOException {
        if (middle == null) {
            return false;
        }
        if (left != null) {
            osw.append(left.charValue());
        }
        for (int col = 0; col < colWidths.length; ++col) {
            AsciiTable.writeRepeated(osw, middle.charValue(), colWidths[col]);
            if (columnSeparator == null || col == colWidths.length - 1) continue;
            osw.write(columnSeparator.charValue());
        }
        if (right != null) {
            osw.append(right.charValue());
        }
        return true;
    }

    private static void writeData(OutputStreamWriter osw, int[] colWidths, OverflowBehaviour[] overflows, HorizontalAlign[] horizontalAligns, String[] contents, Character left, Character columnSeparator, Character right, String lineSeparator, BiFunction<Integer, List<String>, List<String>> styler) throws IOException {
        List linesContents = IntStream.range(0, colWidths.length).mapToObj(i -> {
            String text = i < contents.length && contents[i] != null ? contents[i] : "";
            return LineUtils.lines(text).flatMap(paragraph -> {
                int limit = colWidths[i] - 2;
                if (paragraph.length() <= limit) {
                    return Stream.of(paragraph);
                }
                switch (overflows[i]) {
                    case CLIP_LEFT: {
                        return Stream.of(paragraph.substring(paragraph.length() - limit));
                    }
                    case CLIP: 
                    case CLIP_RIGHT: {
                        return Stream.of(paragraph.substring(0, limit));
                    }
                    case ELLIPSIS_LEFT: {
                        return Stream.of('\u2026' + paragraph.substring(paragraph.length() - limit + 1));
                    }
                    case ELLIPSIS: 
                    case ELLIPSIS_RIGHT: {
                        return Stream.of(paragraph.substring(0, limit - 1) + '\u2026');
                    }
                }
                return LineUtils.splitTextIntoLinesOfMaxLength(paragraph, limit).stream();
            }).collect(Collectors.toList());
        }).collect(Collectors.toList());
        int numLines = linesContents.stream().mapToInt(List::size).max().orElse(0);
        List justifiedLinesContents = styler == null ? null : IntStream.range(0, colWidths.length).mapToObj(col -> (List)styler.apply(col, IntStream.range(0, numLines).mapToObj(i -> AsciiTable.justify(i < ((List)linesContents.get(col)).size() ? (String)((List)linesContents.get(col)).get(i) : "", horizontalAligns[col], colWidths[col], 1)).collect(Collectors.toList()))).collect(Collectors.toList());
        for (int line = 0; line < numLines; ++line) {
            if (left != null) {
                osw.append(left.charValue());
            }
            for (int col2 = 0; col2 < colWidths.length; ++col2) {
                if (justifiedLinesContents == null) {
                    String item = ((List)linesContents.get(col2)).size() <= line ? "" : (String)((List)linesContents.get(col2)).get(line);
                    AsciiTable.writeJustified(osw, item, horizontalAligns[col2], colWidths[col2], 1);
                } else {
                    osw.write((String)((List)justifiedLinesContents.get(col2)).get(line));
                }
                if (columnSeparator == null || col2 == colWidths.length - 1) continue;
                osw.write(columnSeparator.charValue());
            }
            if (right != null) {
                osw.append(right.charValue());
            }
            if (line >= numLines - 1) continue;
            osw.write(lineSeparator);
        }
    }

    private static int[] getColWidths(Column[] columns, String[][] data) {
        int[] result = new int[columns.length];
        for (String[] dataRow : data) {
            for (int col = 0; col < dataRow.length; ++col) {
                if (dataRow[col] == null || dataRow[col].length() <= result[col]) continue;
                result[col] = Math.max(result[col], LineUtils.maxLineLength(dataRow[col]));
            }
        }
        for (int col = 0; col < columns.length; ++col) {
            int length = result[col];
            if (columns[col].getHeader() != null && columns[col].getHeader().length() > length) {
                length = Math.max(length, LineUtils.maxLineLength(columns[col].getHeader()));
            }
            if (columns[col].getFooter() != null && columns[col].getFooter().length() > length) {
                length = Math.max(length, LineUtils.maxLineLength(columns[col].getFooter()));
            }
            result[col] = Math.max(Math.min(columns[col].getMaxWidth(), length + 2), columns[col].getMinWidth());
        }
        return result;
    }

    private static int getNumColumns(Column[] columns, Object[][] data) {
        return Arrays.stream(data).mapToInt(cols -> ((Object[])cols).length).reduce(columns.length, Math::max);
    }

    static String justify(String str, HorizontalAlign align, int length, int minPadding) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(length);
        try (OutputStreamWriter osw = new OutputStreamWriter(baos);){
            AsciiTable.writeJustified(osw, str, align, length, minPadding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return baos.toString();
    }

    static void writeJustified(OutputStreamWriter osw, String str, HorizontalAlign align, int length, int minPadding) throws IOException {
        if (str.length() < length) {
            int leftPadding = align == HorizontalAlign.LEFT ? minPadding : (align == HorizontalAlign.CENTER ? (length - str.length()) / 2 : length - str.length() - minPadding);
            AsciiTable.writeRepeated(osw, ' ', leftPadding);
            osw.write(str);
            AsciiTable.writeRepeated(osw, ' ', length - str.length() - leftPadding);
        } else {
            osw.write(str);
        }
    }

    private static void writeRepeated(OutputStreamWriter osw, char c, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            osw.append(c);
        }
    }

    private static String[][] objectArrayToString(Column[] columns, Object[][] array) {
        int[] numInvisible = new int[Math.max(1, columns.length)];
        for (int i = 0; i < columns.length; ++i) {
            numInvisible[i] = (i == 0 ? 0 : numInvisible[i - 1]) + (columns[i].isVisible() ? 0 : 1);
        }
        if (numInvisible[numInvisible.length - 1] == 0 && array instanceof String[][]) {
            return (String[][])array;
        }
        String[][] stringArray = new String[array.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String[array[i].length - numInvisible[Math.min(numInvisible.length, array[i].length) - 1]];
            int j = 0;
            int k = 0;
            while (k < stringArray[i].length) {
                if (j >= columns.length || columns[j].isVisible()) {
                    stringArray[i][k++] = array[i][j] == null ? null : array[i][j].toString();
                }
                ++j;
            }
        }
        return stringArray;
    }

    public static <T> String getTable(Collection<T> objects, List<ColumnData<T>> columns) {
        return AsciiTable.builder().data(objects, columns).asString();
    }

    public static <T> String getTable(Character[] border, Collection<T> objects, List<ColumnData<T>> columns) {
        return AsciiTable.builder().data(objects, columns).border(border).asString();
    }

    public static String getTable(Object[][] data) {
        return AsciiTable.builder().data(data).asString();
    }

    public static String getTable(String[] header, Object[][] data) {
        return AsciiTable.builder().header(header).data(data).asString();
    }

    public static String getTable(String[] header, String[] footer, Object[][] data) {
        return AsciiTable.builder().header(header).footer(footer).data(data).asString();
    }

    public static String getTable(Character[] border, String[] header, String[] footer, Object[][] data) {
        return AsciiTable.builder().header(header).footer(footer).border(border).data(data).asString();
    }

    public static String getTable(Column[] columns, Object[][] data) {
        return AsciiTable.builder().data(columns, data).asString();
    }

    public static String getTable(Character[] border, Column[] rawColumns, Object[][] data) {
        return AsciiTable.builder().data(rawColumns, data).border(border).asString();
    }

    public static AsciiTableBuilder builder() {
        return new AsciiTableBuilder();
    }
}

