/*
 * Decompiled with CFR 0.152.
 */
package com.github.gantsign.maven.plugin.ktlint.internal;

import com.github.gantsign.maven.plugin.ktlint.internal.AbstractLintSupport;
import com.github.gantsign.maven.plugin.ktlint.internal.Sources;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.RuleProviderKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\t\u0010\u0017\u001a\u00020\u0012H\u0086\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/gantsign/maven/plugin/ktlint/internal/Format;", "Lcom/github/gantsign/maven/plugin/ktlint/internal/AbstractLintSupport;", "log", "Lorg/apache/maven/plugin/logging/Log;", "basedir", "Ljava/io/File;", "modulePackaging", "", "sources", "", "Lcom/github/gantsign/maven/plugin/ktlint/internal/Sources;", "android", "", "enableExperimentalRules", "(Lorg/apache/maven/plugin/logging/Log;Ljava/io/File;Ljava/lang/String;Ljava/util/List;ZZ)V", "formattedFileCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "formatFile", "", "ktLintRuleEngine", "Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "invoke", "ktlint-maven-plugin"})
@SourceDebugExtension(value={"SMAP\nFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Format.kt\ncom/github/gantsign/maven/plugin/ktlint/internal/Format\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n259#2:158\n259#2:159\n1#3:160\n37#4,2:161\n37#4,2:163\n11065#5:165\n11400#5,3:166\n1855#6,2:169\n*S KotlinDebug\n*F\n+ 1 Format.kt\ncom/github/gantsign/maven/plugin/ktlint/internal/Format\n*L\n61#1:158\n64#1:159\n102#1:161,2\n103#1:163,2\n113#1:165\n113#1:166,3\n115#1:169,2\n*E\n"})
public final class Format
extends AbstractLintSupport {
    @NotNull
    private final String modulePackaging;
    @NotNull
    private final List<Sources> sources;
    @NotNull
    private final AtomicInteger formattedFileCount;

    public Format(@NotNull Log log, @NotNull File basedir, @NotNull String modulePackaging, @NotNull List<Sources> sources, boolean android, boolean enableExperimentalRules) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)basedir, (String)"basedir");
        Intrinsics.checkNotNullParameter((Object)modulePackaging, (String)"modulePackaging");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        super(log, basedir, android, enableExperimentalRules);
        this.modulePackaging = modulePackaging;
        this.sources = sources;
        this.formattedFileCount = new AtomicInteger();
    }

    /*
     * WARNING - void declaration
     */
    public final void invoke() {
        EditorConfigOverride editorConfigOverride;
        EditorConfigOverride editorConfigOverride2;
        Pair[] pairArray;
        void $this$applyIf$iv;
        EditorConfigOverride editorConfigOverride3 = EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE();
        boolean if$iv = this.getEnableExperimentalRules();
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$invoke_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            this.getLog().debug((CharSequence)"Add editor config override to allow the experimental rule set");
            pairArray = new Pair[]{TuplesKt.to((Object)RuleExecutionEditorConfigPropertyKt.getEXPERIMENTAL_RULES_EXECUTION_PROPERTY(), (Object)RuleExecution.enabled)};
            editorConfigOverride2 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$invoke_u24lambda_u240, pairArray);
        } else {
            editorConfigOverride2 = $this$applyIf$iv;
        }
        $this$applyIf$iv = editorConfigOverride2;
        if$iv = this.getAndroid();
        $i$f$applyIf = false;
        if (if$iv) {
            void $this$invoke_u24lambda_u241 = $this$applyIf$iv;
            boolean bl = false;
            this.getLog().debug((CharSequence)"Add editor config override to set code style to 'android_studio'");
            pairArray = new Pair[]{TuplesKt.to((Object)CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), (Object)CodeStyleValue.android_studio)};
            editorConfigOverride = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$invoke_u24lambda_u241, pairArray);
        } else {
            editorConfigOverride = $this$applyIf$iv;
        }
        void editorConfigOverride4 = editorConfigOverride;
        EditorConfigDefaults editorConfigDefaults = EditorConfigDefaults.Companion.load(null, RuleProviderKt.propertyTypes((Collection)this.getRuleProviders()));
        KtLintRuleEngine ktLintRuleEngine = new KtLintRuleEngine(this.getRuleProviders(), editorConfigDefaults, (EditorConfigOverride)editorConfigOverride4, false, null, 16, null);
        Set checkedFiles = new LinkedHashSet();
        for (Sources sources : this.sources) {
            boolean isIncluded = sources.component1();
            Set<File> sourceRoots = sources.component2();
            String[] includes = sources.component3();
            Set<String> excludes = sources.component4();
            if (!isIncluded) {
                this.getLog().debug((CharSequence)("Source roots not included: " + sourceRoots));
                continue;
            }
            for (File sourceRoot : sourceRoots) {
                void $this$mapTo$iv$iv;
                Object object;
                block16: {
                    String[] $this$toTypedArray$iv;
                    block15: {
                        String[] stringArray;
                        if (!sourceRoot.exists()) {
                            String msg = "Source root doesn't exist: " + FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir());
                            if (Intrinsics.areEqual((Object)this.modulePackaging, (Object)"pom")) {
                                this.getLog().debug((CharSequence)msg);
                                continue;
                            }
                            this.getLog().warn((CharSequence)msg);
                            continue;
                        }
                        if (!sourceRoot.isDirectory()) {
                            throw new MojoFailureException("Source root is not a directory: " + FilesKt.toRelativeString((File)sourceRoot, (File)this.getBasedir()));
                        }
                        String[] p0 = stringArray = includes;
                        boolean bl = false;
                        object = !p0.isEmpty() ? stringArray : null;
                        if (object == null) break block15;
                        $this$toTypedArray$iv = object;
                        boolean $i$f$toTypedArray = false;
                        String[] thisCollection$iv = $this$toTypedArray$iv;
                        object = thisCollection$iv.toArray(new String[0]);
                        if (object != null) break block16;
                    }
                    $this$toTypedArray$iv = new String[]{"**/*.kt"};
                    object = $this$toTypedArray$iv;
                }
                String[] includesArray = object;
                Collection $this$toTypedArray$iv = excludes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] excludesArray = thisCollection$iv.toArray(new String[0]);
                DirectoryScanner $this$invoke_u24lambda_u242 = $i$f$toTypedArray = new DirectoryScanner();
                boolean bl = false;
                $this$invoke_u24lambda_u242.setIncludes(Arrays.copyOf(includesArray, includesArray.length));
                $this$invoke_u24lambda_u242.setExcludes(Arrays.copyOf(excludesArray, excludesArray.length));
                $this$invoke_u24lambda_u242.setBasedir(sourceRoot);
                $this$invoke_u24lambda_u242.setCaseSensitive(true);
                DirectoryScanner ds = $i$f$toTypedArray;
                ds.scan();
                String[] stringArray = ds.getIncludedFiles();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getIncludedFiles(...)");
                Object[] $this$map$iv = stringArray;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new File(sourceRoot, (String)it));
                }
                List sourceFiles = (List)destination$iv$iv;
                Iterable $this$forEach$iv = sourceFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl3 = false;
                    File file2 = file.getCanonicalFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getCanonicalFile(...)");
                    if (!checkedFiles.add(file2)) continue;
                    this.formatFile(ktLintRuleEngine, Code.Companion.fromFile(file));
                }
            }
        }
        this.getLog().info((CharSequence)(this.formattedFileCount.get() + " file(s) formatted."));
    }

    private final void formatFile(KtLintRuleEngine ktLintRuleEngine, Code code) {
        Path path = code.getFilePath();
        Intrinsics.checkNotNull((Object)path);
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        String baseRelativePath = FilesKt.toRelativeString((File)file, (File)this.getBasedir());
        this.getLog().debug((CharSequence)("checking format: " + baseRelativePath));
        String beforeFileContent = code.getContent();
        try {
            File file2;
            String string;
            String formattedFileContent = string = ktLintRuleEngine.format(code, (Function2)new Function2<LintError, Boolean, Unit>(baseRelativePath, this){
                final /* synthetic */ String $baseRelativePath;
                final /* synthetic */ Format this$0;
                {
                    this.$baseRelativePath = $baseRelativePath;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(@NotNull LintError lintError, boolean corrected) {
                    Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
                    String errMsg = this.$baseRelativePath + ':' + lintError.getLine() + ':' + lintError.getCol() + ": " + lintError.getDetail();
                    this.this$0.getLog().debug((CharSequence)("Format " + (corrected ? "fixed" : "could not fix") + " > " + errMsg));
                }
            });
            boolean bl = false;
            Path path2 = code.getFilePath();
            if (path2 != null && (file2 = path2.toFile()) != null) {
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                FilesKt.writeText((File)file2, (String)formattedFileContent, (Charset)charset);
            }
            if (!Intrinsics.areEqual((Object)beforeFileContent, (Object)formattedFileContent)) {
                this.getLog().debug((CharSequence)("Format fixed > " + baseRelativePath));
                this.formattedFileCount.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }
}

