/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.javaparsermodel.contexts;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.resolution.MethodUsage;
import com.github.javaparser.resolution.Navigator;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedConstructorDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedMethodDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeParameterDeclaration;
import com.github.javaparser.resolution.logic.FunctionalInterfaceLogic;
import com.github.javaparser.resolution.logic.InferenceContext;
import com.github.javaparser.resolution.logic.MethodResolutionLogic;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedLambdaConstraintType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.javaparsermodel.contexts.ExpressionContext;
import com.github.javaparser.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MethodReferenceExprContext
extends ExpressionContext<MethodReferenceExpr> {
    public MethodReferenceExprContext(MethodReferenceExpr wrappedNode, TypeSolver typeSolver) {
        super(wrappedNode, typeSolver);
    }

    public SymbolReference<ResolvedMethodDeclaration> solveMethod(String name, List<ResolvedType> argumentsTypes, boolean staticOnly) {
        if ("new".equals(name)) {
            throw new UnsupportedOperationException("Constructor calls not yet resolvable");
        }
        argumentsTypes.addAll(this.inferArgumentTypes());
        Collection<ResolvedReferenceTypeDeclaration> rrtds = this.findTypeDeclarations(Optional.of(((MethodReferenceExpr)this.wrappedNode).getScope()));
        if (rrtds.isEmpty()) {
            rrtds = Collections.singleton(this.typeSolver.getSolvedJavaLangObject());
        }
        for (ResolvedReferenceTypeDeclaration rrtd : rrtds) {
            SymbolReference firstResAttempt = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)rrtd, (String)name, argumentsTypes, (boolean)false);
            if (firstResAttempt.isSolved()) {
                return firstResAttempt;
            }
            SymbolReference secondResAttempt = MethodResolutionLogic.solveMethodInType((ResolvedTypeDeclaration)rrtd, (String)name, Collections.emptyList(), (boolean)false);
            if (!secondResAttempt.isSolved()) continue;
            return secondResAttempt;
        }
        return SymbolReference.unsolved();
    }

    private List<ResolvedType> inferArgumentTypes() {
        if (Navigator.demandParentNode((Node)this.wrappedNode) instanceof MethodCallExpr) {
            MethodCallExpr methodCallExpr = (MethodCallExpr)Navigator.demandParentNode((Node)this.wrappedNode);
            MethodUsage methodUsage = JavaParserFacade.get(this.typeSolver).solveMethodAsUsage(methodCallExpr);
            int pos = methodCallExpr.getArgumentPosition((Expression)this.wrappedNode);
            ResolvedMethodDeclaration rmd = methodUsage.getDeclaration();
            ResolvedType lambdaType = rmd.hasVariadicParameter() && pos >= rmd.getNumberOfParams() - 1 ? rmd.getLastParam().getType().asArrayType().getComponentType() : methodUsage.getParamType(pos);
            return this.resolveLambdaTypes(lambdaType);
        }
        if (Navigator.demandParentNode((Node)this.wrappedNode) instanceof ObjectCreationExpr) {
            ObjectCreationExpr objectCreationExpr = (ObjectCreationExpr)Navigator.demandParentNode((Node)this.wrappedNode);
            ResolvedConstructorDeclaration rcd = (ResolvedConstructorDeclaration)JavaParserFacade.get(this.typeSolver).solve(objectCreationExpr).getCorrespondingDeclaration();
            int pos = objectCreationExpr.getArgumentPosition((Expression)this.wrappedNode);
            ResolvedType lambdaType = rcd.hasVariadicParameter() && pos >= rcd.getNumberOfParams() - 1 ? rcd.getLastParam().getType().asArrayType().getComponentType() : rcd.getParam(pos).getType();
            return this.resolveLambdaTypes(lambdaType);
        }
        if (Navigator.demandParentNode((Node)this.wrappedNode) instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)Navigator.demandParentNode((Node)this.wrappedNode);
            ResolvedType t = JavaParserFacade.get(this.typeSolver).convertToUsage(variableDeclarator.getType());
            Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t);
            if (functionalMethod.isPresent()) {
                ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
                for (ResolvedType lambdaType : ((MethodUsage)functionalMethod.get()).getParamTypes()) {
                    HashMap inferredTypes = new HashMap();
                    if (lambdaType.isReferenceType()) {
                        for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                            if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                            ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                            lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                        }
                    } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                        lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                    }
                    resolvedTypes.add(lambdaType);
                }
                return resolvedTypes;
            }
            throw new UnsupportedOperationException();
        }
        if (Navigator.demandParentNode((Node)this.wrappedNode) instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)Navigator.demandParentNode((Node)this.wrappedNode);
            Optional optDeclaration = returnStmt.findAncestor(new Class[]{MethodDeclaration.class});
            if (optDeclaration.isPresent()) {
                ResolvedType t = JavaParserFacade.get(this.typeSolver).convertToUsage(((MethodDeclaration)optDeclaration.get()).asMethodDeclaration().getType());
                Optional functionalMethod = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)t);
                if (functionalMethod.isPresent()) {
                    ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
                    for (ResolvedType lambdaType : ((MethodUsage)functionalMethod.get()).getParamTypes()) {
                        HashMap inferredTypes = new HashMap();
                        if (lambdaType.isReferenceType()) {
                            for (Pair entry : lambdaType.asReferenceType().getTypeParametersMap()) {
                                if (!((ResolvedType)entry.b).isTypeVariable() || !((ResolvedType)entry.b).asTypeParameter().declaredOnType()) continue;
                                ResolvedType ot = t.asReferenceType().typeParametersMap().getValue((ResolvedTypeParameterDeclaration)entry.a);
                                lambdaType = lambdaType.replaceTypeVariables((ResolvedTypeParameterDeclaration)entry.a, ot, inferredTypes);
                            }
                        } else if (lambdaType.isTypeVariable() && lambdaType.asTypeParameter().declaredOnType()) {
                            lambdaType = t.asReferenceType().typeParametersMap().getValue(lambdaType.asTypeParameter());
                        }
                        resolvedTypes.add(lambdaType);
                    }
                    return resolvedTypes;
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private List<ResolvedType> resolveLambdaTypes(ResolvedType lambdaType) {
        Optional functionalMethodOpt = FunctionalInterfaceLogic.getFunctionalMethod((ResolvedType)lambdaType);
        if (functionalMethodOpt.isPresent()) {
            MethodUsage functionalMethod = (MethodUsage)functionalMethodOpt.get();
            ArrayList<ResolvedType> resolvedTypes = new ArrayList<ResolvedType>();
            for (ResolvedType type : functionalMethod.getParamTypes()) {
                InferenceContext inferenceContext = new InferenceContext(this.typeSolver);
                inferenceContext.addPair((ResolvedType)new ReferenceTypeImpl(functionalMethod.declaringType()), lambdaType);
                ResolvedType argType = inferenceContext.resolve(inferenceContext.addSingle(type));
                ResolvedLambdaConstraintType conType = argType.isWildcard() ? ResolvedLambdaConstraintType.bound((ResolvedType)argType.asWildcard().getBoundedType()) : ResolvedLambdaConstraintType.bound((ResolvedType)argType);
                resolvedTypes.add((ResolvedType)conType);
            }
            return resolvedTypes;
        }
        throw new UnsupportedOperationException();
    }
}

