/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf;

import com.github.javatlacati.contiperf.report.HtmlReportModule;
import com.github.javatlacati.contiperf.report.ReportContext;
import java.io.File;

public class Config {
    private static final String DEFAULT_REPORT_FOLDER_NAME = "contiperf-report";
    public static final String SYSPROP_ACTIVE = "contiperf.active";
    public static final String SYSPROP_CONFIG_FILENAME = "contiperf.config";
    public static final String DEFAULT_CONFIG_FILENAME = "contiperf.config.xml";
    private static Config instance;

    public boolean active() {
        String sysprop = System.getProperty(SYSPROP_ACTIVE);
        return sysprop == null || !"false".equals(sysprop.trim().toLowerCase());
    }

    public static String getConfigFileName() {
        String filename = System.getProperty(SYSPROP_CONFIG_FILENAME);
        if (filename == null || filename.trim().length() == 0) {
            filename = DEFAULT_CONFIG_FILENAME;
        }
        return filename;
    }

    public static Config instance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public int getInvocationCount(String testId) {
        return -1;
    }

    public ReportContext createDefaultReportContext(Class<? extends AssertionError> failureClass) {
        File reportFolder = this.getReportFolder();
        ReportContext context = new ReportContext(reportFolder, failureClass);
        context.addReportModule(new HtmlReportModule());
        return context;
    }

    public File getReportFolder() {
        File targetDir = new File("target");
        File reportFolder = targetDir.exists() ? new File(targetDir, DEFAULT_REPORT_FOLDER_NAME) : new File(DEFAULT_REPORT_FOLDER_NAME);
        return reportFolder;
    }
}

