/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf;

import com.github.javatlacati.contiperf.AbstractInvocationRunner;
import com.github.javatlacati.contiperf.ArgumentsProvider;
import com.github.javatlacati.contiperf.Invoker;
import com.github.javatlacati.contiperf.WaitTimer;
import com.github.javatlacati.contiperf.util.ContiPerfUtil;
import java.util.concurrent.atomic.AtomicLong;

public class CountRunner
extends AbstractInvocationRunner {
    private ArgumentsProvider argsProvider;
    private Invoker invoker;
    private AtomicLong invocationsLeft;

    public CountRunner(Invoker invoker, ArgumentsProvider argsProvider, WaitTimer waitTimer, AtomicLong invocationsLeft) {
        super(waitTimer);
        this.invoker = invoker;
        this.argsProvider = argsProvider;
        this.invocationsLeft = invocationsLeft;
    }

    @Override
    public void run() {
        try {
            while (this.invocationsLeft.getAndDecrement() > 0L) {
                this.invoker.invoke(this.argsProvider.next());
                this.sleep();
            }
        }
        catch (Exception e) {
            throw ContiPerfUtil.executionError(e);
        }
    }

    @Override
    public void close() {
        this.invoker = null;
    }
}

