/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf;

import com.github.javatlacati.contiperf.Clock;
import com.github.javatlacati.contiperf.WaitTimer;
import com.github.javatlacati.contiperf.clock.SystemClock;
import com.github.javatlacati.contiperf.timer.None;

public class ExecutionConfig {
    private int invocations;
    private int duration;
    private Clock[] clocks;
    private int rampUp;
    private int warmUp;
    private int threads;
    WaitTimer waitTimer;
    private boolean cancelOnViolation;

    public ExecutionConfig(int invocations) {
        this(invocations, 1, -1, new Clock[]{new SystemClock()}, 0, 0, false, None.class, new double[0]);
    }

    public ExecutionConfig(int invocations, int threads, int duration, Clock[] clocks, int rampUp, int warmUp, boolean cancelOnViolation, Class<? extends WaitTimer> waitTimerClass, double[] waitParams) {
        this.invocations = invocations;
        this.threads = threads;
        this.duration = duration;
        this.clocks = clocks;
        this.rampUp = rampUp;
        this.warmUp = warmUp;
        this.cancelOnViolation = cancelOnViolation;
        try {
            this.waitTimer = waitTimerClass.newInstance();
            this.waitTimer.init(waitParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getInvocations() {
        return this.invocations;
    }

    public void setInvocations(int invocations) {
        this.invocations = invocations;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getRampUp() {
        return this.rampUp;
    }

    public int getWarmUp() {
        return this.warmUp;
    }

    public WaitTimer getWaitTimer() {
        return this.waitTimer;
    }

    public boolean isCancelOnViolation() {
        return this.cancelOnViolation;
    }

    public String toString() {
        return (this.invocations > 0 ? this.invocations + " invocations" : "Running" + this.duration + " ms") + " with " + this.threads + " threads";
    }

    public Clock[] getClocks() {
        return this.clocks;
    }
}

