/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf;

import com.github.javatlacati.contiperf.AbstractInvocationRunner;
import com.github.javatlacati.contiperf.ArgumentsProvider;
import com.github.javatlacati.contiperf.Invoker;
import com.github.javatlacati.contiperf.WaitTimer;
import com.github.javatlacati.contiperf.util.ContiPerfUtil;

public class TimedRunner
extends AbstractInvocationRunner {
    private long duration;
    private ArgumentsProvider argsProvider;
    private Invoker invoker;

    public TimedRunner(Invoker invoker, ArgumentsProvider argsProvider, WaitTimer waitTimer, long duration) {
        super(waitTimer);
        this.invoker = invoker;
        this.argsProvider = argsProvider;
        this.duration = duration;
    }

    @Override
    public void run() {
        try {
            long start = System.currentTimeMillis();
            long endTime = start + this.duration;
            do {
                this.invoker.invoke(this.argsProvider.next());
                this.sleep();
            } while (System.currentTimeMillis() < endTime);
        }
        catch (Exception e) {
            throw ContiPerfUtil.executionError(e);
        }
    }

    @Override
    public void close() {
        this.invoker = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.duration + " ms)";
    }
}

