/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.junit;

import com.github.javatlacati.contiperf.Config;
import com.github.javatlacati.contiperf.ExecutionLogger;
import com.github.javatlacati.contiperf.junit.PerformanceRequirementFailedError;
import com.github.javatlacati.contiperf.report.LoggerModuleAdapter;
import com.github.javatlacati.contiperf.report.ReportContext;
import com.github.javatlacati.contiperf.report.ReportModule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class JUnitReportContext
extends ReportContext {
    public static final Class<PerformanceRequirementFailedError> FAILURE_CLASS = PerformanceRequirementFailedError.class;

    public JUnitReportContext() {
        super(Config.instance().getReportFolder(), FAILURE_CLASS);
    }

    public static JUnitReportContext createInstance(Object suite) {
        List<ReportModule> modules = JUnitReportContext.parseReportModules(suite);
        JUnitReportContext context = new JUnitReportContext();
        for (ReportModule module : modules) {
            context.addReportModule(module);
        }
        return context;
    }

    private static List<ReportModule> parseReportModules(Object suite) {
        ArrayList<ReportModule> modules = new ArrayList<ReportModule>();
        if (suite != null) {
            for (Field field : suite.getClass().getFields()) {
                try {
                    if (ReportModule.class.isAssignableFrom(field.getType())) {
                        modules.add((ReportModule)field.get(suite));
                        continue;
                    }
                    if (!ExecutionLogger.class.isAssignableFrom(field.getType())) continue;
                    modules.add(new LoggerModuleAdapter((ExecutionLogger)field.get(suite)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return modules;
    }
}

