/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.report;

import com.github.javatlacati.contiperf.ExecutionConfig;
import com.github.javatlacati.contiperf.PerformanceRequirement;
import com.github.javatlacati.contiperf.report.AbstractReportModule;
import com.github.javatlacati.stat.LatencyCounter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class CSVInvocationReportModule
extends AbstractReportModule {
    private static final String FILE_SUFFIX = ".inv.csv";
    private PrintWriter out;

    @Override
    public String getReportReferenceLabel(String serviceId) {
        return "Invocations as CSV";
    }

    @Override
    public String getReportReference(String serviceId) {
        return serviceId != null ? this.filename(serviceId) : null;
    }

    @Override
    public void starting(String serviceId) {
        this.createFile(serviceId);
    }

    @Override
    public synchronized void invoked(String serviceId, int latency, long startTime) {
        this.out.print(latency);
        this.out.print(',');
        this.out.println(startTime);
    }

    @Override
    public void completed(String serviceId, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement) {
        if (this.out != null) {
            this.out.close();
        }
    }

    private void createFile(String serviceId) {
        try {
            String filename = this.filename(serviceId);
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
            this.out.println("latency,startTimeNanos");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    private String filename(String serviceId) {
        return this.context.getReportFolder() + File.separator + serviceId + FILE_SUFFIX;
    }
}

