/*
 * Decompiled with CFR 0.152.
 */
package com.github.javatlacati.contiperf.report;

import com.github.javatlacati.contiperf.ExecutionConfig;
import com.github.javatlacati.contiperf.PerformanceRequirement;
import com.github.javatlacati.contiperf.report.AbstractReportModule;
import com.github.javatlacati.contiperf.util.ContiPerfUtil;
import com.github.javatlacati.stat.LatencyCounter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class CSVSummaryReportModule
extends AbstractReportModule {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Set<File> usedFiles = new HashSet<File>();
    private File file = null;

    @Override
    public String getReportReferenceLabel(String serviceId) {
        return serviceId == null ? "CSV Summary" : null;
    }

    @Override
    public String getReportReference(String serviceId) {
        return serviceId == null ? this.filename() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void starting(String serviceId) {
        Set<File> set = usedFiles;
        synchronized (set) {
            this.file = new File(this.context.getReportFolder(), this.filename());
            if (!usedFiles.contains(this.file) && this.file.exists()) {
                if (!this.file.delete()) {
                    throw new RuntimeException("Previous file version could not be deleted: " + this.file);
                }
                usedFiles.add(this.file);
            }
            if (!this.file.exists()) {
                this.writeHeader(serviceId);
            }
        }
    }

    @Override
    public void completed(String serviceId, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement) {
        this.writeStats(serviceId, counters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(String serviceId) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file, true);
            String line = "serviceId,startTime,duration,invocations,min,average,median,90%,95%,99%,max" + LINE_SEPARATOR;
            ((OutputStream)out).write(line.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStats(String serviceId, LatencyCounter[] counters) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file, true);
            DecimalFormat decForm = new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.US));
            decForm.setGroupingUsed(false);
            LatencyCounter mainCounter = counters[0];
            String avg = decForm.format(mainCounter.averageLatency());
            String message = serviceId + ',' + mainCounter.getStartTime() + ',' + mainCounter.duration() + ',' + mainCounter.sampleCount() + ',' + mainCounter.minLatency() + ',' + avg + ',' + mainCounter.percentileLatency(50) + ',' + mainCounter.percentileLatency(90) + ',' + mainCounter.percentileLatency(95) + ',' + mainCounter.percentileLatency(99) + ',' + mainCounter.maxLatency() + LINE_SEPARATOR;
            ((OutputStream)out).write(message.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    private String filename() {
        return "summary.csv";
    }
}

