/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionEventListener;
import cubrid.jdbc.driver.CUBRIDConnectionPoolDataSource;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

abstract class CUBRIDConnectionPoolManager {
    private static Hashtable<String, CUBRIDConnectionEventListener> connectionPooltable = new Hashtable();
    private static Hashtable<String, CUBRIDConnectionPoolDataSource> poolDataSourceTable = new Hashtable();

    CUBRIDConnectionPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection(CUBRIDConnectionPoolDataSource pds, String user, String passwd) throws SQLException {
        CUBRIDConnectionEventListener cp;
        String key = pds.getDataSourceID(user);
        Hashtable<String, CUBRIDConnectionEventListener> hashtable = connectionPooltable;
        synchronized (hashtable) {
            cp = connectionPooltable.get(key);
            if (cp == null) {
                cp = CUBRIDConnectionPoolManager.addConnectionPool(key, pds);
            }
        }
        return cp.getConnection(user, passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CUBRIDConnectionPoolDataSource getConnectionPoolDataSource(String dsName) throws SQLException {
        CUBRIDConnectionPoolDataSource cpds;
        Hashtable<String, CUBRIDConnectionPoolDataSource> hashtable = poolDataSourceTable;
        synchronized (hashtable) {
            cpds = poolDataSourceTable.get(dsName);
            if (cpds == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    cpds = (CUBRIDConnectionPoolDataSource)ctx.lookup(dsName);
                }
                catch (NamingException e) {
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, e.toString(), (Throwable)e);
                }
                poolDataSourceTable.put(dsName, cpds);
            }
        }
        return cpds;
    }

    private static CUBRIDConnectionEventListener addConnectionPool(String key, CUBRIDConnectionPoolDataSource pds) {
        CUBRIDConnectionEventListener cp = new CUBRIDConnectionEventListener(pds);
        connectionPooltable.put(key, cp);
        return cp;
    }
}

