/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Date;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class CUBRIDDataSourceBase {
    private String databaseName = null;
    private String dataSourceName = null;
    private String description = null;
    private String networkProtocol = null;
    private String password = null;
    private int portNumber = 0;
    private String roleName = null;
    private String serverName = null;
    private String user = null;
    private String url = null;
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private String dataSourceID = null;

    protected CUBRIDDataSourceBase() {
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNetworkProtocol() {
        return this.networkProtocol;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public int getPort() {
        return this.getPortNumber();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getUser() {
        return this.user;
    }

    public String getUrl() {
        return this.url;
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public void setDataSourceName(String dsName) {
        this.dataSourceName = dsName;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setNetworkProtocol(String netProtocol) {
        this.networkProtocol = netProtocol;
    }

    public void setPassword(String psswd) {
        this.password = psswd;
    }

    public void setPortNumber(int p) {
        this.portNumber = p;
    }

    void setPort(int p) {
        this.setPortNumber(p);
    }

    public void setRoleName(String rName) {
        this.roleName = rName;
    }

    public void setServerName(String svName) {
        this.serverName = svName;
    }

    public void setUser(String uName) {
        this.user = uName;
    }

    public void setUrl(String urlString) {
        this.url = urlString;
    }

    public void setURL(String urlString) {
        this.setUrl(urlString);
    }

    synchronized String getDataSourceID(String username) {
        if (username == null) {
            username = "";
        }
        if (this.dataSourceID == null) {
            if (this.url != null) {
                this.dataSourceID = this.url;
            } else {
                String host;
                String hostName = this.serverName != null ? this.serverName : "";
                try {
                    host = InetAddress.getByName(hostName).getHostAddress();
                }
                catch (Exception e) {
                    host = hostName;
                }
                this.dataSourceID = "jdbc:cubrid:" + host + ":" + this.portNumber + ":" + (this.databaseName != null ? this.databaseName : "");
            }
        }
        return this.dataSourceID + ":" + username;
    }

    protected Reference getProperties(Reference ref) {
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        ref.add(new StringRefAddr("portNumber", Integer.toString(this.getPortNumber())));
        ref.add(new StringRefAddr("url", this.getUrl()));
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("networkProtocol", this.getNetworkProtocol()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        ref.add(new StringRefAddr("roleName", this.getRoleName()));
        ref.add(new StringRefAddr("user", this.getUser()));
        return ref;
    }

    protected void setProperties(Reference ref) {
        this.setServerName((String)ref.get("serverName").getContent());
        this.setDatabaseName((String)ref.get("databaseName").getContent());
        this.setPortNumber(Integer.parseInt((String)ref.get("portNumber").getContent()));
        this.setUrl((String)ref.get("url").getContent());
        this.setDataSourceName((String)ref.get("dataSourceName").getContent());
        this.setDescription((String)ref.get("description").getContent());
        this.setNetworkProtocol((String)ref.get("networkProtocol").getContent());
        this.setPassword((String)ref.get("password").getContent());
        this.setRoleName((String)ref.get("roleName").getContent());
        this.setUser((String)ref.get("user").getContent());
    }

    protected void writeLog(String log) {
        if (this.logWriter != null) {
            Date dt = new Date(System.currentTimeMillis());
            this.logWriter.println("[" + dt + "] " + log);
            this.logWriter.flush();
        }
    }
}

