/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBufferedOutputStream;
import cubrid.jdbc.driver.CUBRIDBufferedWriter;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSetMetaData;
import cubrid.jdbc.driver.CUBRIDStatement;
import cubrid.jdbc.jci.UBatchResult;
import cubrid.jdbc.jci.UColumnInfo;
import cubrid.jdbc.jci.UStatement;
import cubrid.sql.CUBRIDOID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class CUBRIDPreparedStatement
extends CUBRIDStatement
implements PreparedStatement {
    protected int autoGeneratedKeys;
    private boolean first_result_type;

    protected CUBRIDPreparedStatement(CUBRIDConnection c, UStatement us, int t, int concur, int hold, int autoGeneratedKeys) {
        super(c, t, concur, hold);
        this.u_stmt = us;
        this.first_result_type = this.u_stmt.getSqlType();
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    long begin = 0L;
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    if (!this.first_result_type && this.u_stmt.getCommandType() != 126) {
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeQuery, null);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    if (this.current_result_set != null) {
                        this.current_result_set.complete_on_close = true;
                    }
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, this.u_stmt.getQuery(), this.u_stmt.getBindParameter());
                    }
                    return this.current_result_set;
                }
            }
        }
        catch (NullPointerException e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    long begin = 0L;
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    if (this.first_result_type) {
                        throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_query_type_for_executeUpdate, null);
                    }
                    this.executeCore(false);
                    this.getMoreResults();
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    }
                    if (this.u_stmt.getCommandType() != 126) {
                        this.complete();
                    }
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, this.u_stmt.getQuery(), this.u_stmt.getBindParameter());
                    }
                    return this.update_count;
                }
            }
        }
        catch (NullPointerException e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindNull(parameterIndex - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setString(int parameterIndex, String x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        if (x == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(parameterIndex - 1, x);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        byte[] value = new byte[length];
        int len = 0;
        try {
            len = x.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, new String(value, 0, len));
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIsOpen();
        if (x == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(parameterIndex - 1, x);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        byte[] value = new byte[length];
        int len = 0;
        try {
            len = x.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        byte[] value2 = new byte[len];
        for (int i = 0; i < len; ++i) {
            value2[i] = value[i];
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, value2);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearParameters() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.clearBind();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
            return;
        }
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            if (targetSqlType == 2 || targetSqlType == 3) {
                Number n = null;
                try {
                    n = (Number)x;
                }
                catch (Exception e) {
                    this.u_stmt.bind(parameterIndex - 1, x);
                }
                this.u_stmt.bind(parameterIndex - 1, new BigDecimal(n.toString()).setScale(scale));
            } else {
                this.u_stmt.bind(parameterIndex - 1, x);
            }
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkIsOpen();
        this.setObject(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
            return;
        }
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    long begin = 0L;
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    if (this.u_con.getLogSlowQuery()) {
                        begin = System.currentTimeMillis();
                    }
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    this.executeCore(true);
                    this.getMoreResults();
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.MakeAutoGeneratedKeysResultSet();
                    }
                    if (this.u_stmt.getNumQueriesExecuted() == 1) {
                        byte cmdType;
                        if (this.current_result_set != null) {
                            this.current_result_set.complete_on_close = true;
                        }
                        if ((cmdType = this.u_stmt.getCommandType()) != 126 && cmdType != 21) {
                            this.complete();
                        }
                    }
                    if (this.u_con.getLogSlowQuery()) {
                        long end = System.currentTimeMillis();
                        this.u_con.logSlowQuery(begin, end, this.u_stmt.getQuery(), this.u_stmt.getBindParameter());
                    }
                    return this.first_result_type;
                }
            }
        }
        catch (NullPointerException e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addBatch() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.addBatch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIsOpen();
        if (reader == null) {
            UStatement uStatement = this.u_stmt;
            synchronized (uStatement) {
                this.u_stmt.bind(parameterIndex - 1, reader);
                this.error = this.u_stmt.getRecentError();
            }
            this.checkBindError();
            return;
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        char[] value = new char[length];
        int len = 0;
        try {
            len = reader.read(value);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bind(parameterIndex - 1, new String(value, 0, len));
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindBlob(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindClob(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.checkIsOpen();
        Blob blob = this.con.createBlob();
        OutputStream out = blob.setBinaryStream(1L);
        try {
            ((CUBRIDBufferedOutputStream)out).streamCopyFromInputStream(inputStream, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        this.setBlob(parameterIndex, blob);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.checkIsOpen();
        Blob blob = this.con.createBlob();
        OutputStream out = blob.setBinaryStream(1L);
        try {
            ((CUBRIDBufferedOutputStream)out).streamCopyFromInputStream(inputStream, length);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        this.setBlob(parameterIndex, blob);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        this.checkIsOpen();
        Clob clob = this.con.createClob();
        Writer out = clob.setCharacterStream(1L);
        try {
            ((CUBRIDBufferedWriter)out).streamCopyFromReader(reader, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        this.setClob(parameterIndex, clob);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, 2005);
            return;
        }
        this.checkIsOpen();
        Clob clob = this.con.createClob();
        Writer out = clob.setCharacterStream(1L);
        try {
            ((CUBRIDBufferedWriter)out).streamCopyFromReader(reader, length);
        }
        catch (IOException e) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.ioexception_in_stream, e);
        }
        this.setClob(parameterIndex, clob);
    }

    public void setArray(int i, Array x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkIsOpen();
        UColumnInfo[] col_info = null;
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            col_info = this.u_stmt.getColumnInfo();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
        if (col_info.length == 0) {
            return null;
        }
        return new CUBRIDResultSetMetaData(col_info);
    }

    public synchronized void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    public synchronized void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    public synchronized void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    public synchronized void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    this.setShardId(-1);
                    if (this.is_closed) {
                        return;
                    }
                    this.complete();
                    this.is_closed = true;
                    if (this.u_stmt != null) {
                        this.u_stmt.close();
                        this.u_stmt = null;
                    }
                    this.con.removeStatement(this);
                    this.con = null;
                    this.u_con = null;
                    this.error = null;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearBatch() throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.clearBatch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    this.setShardId(-1);
                    this.checkIsOpen();
                    if (!this.u_stmt.hasBatch()) {
                        return new int[0];
                    }
                    this.u_con.setBeginTime();
                    if (!this.completed) {
                        this.complete();
                    }
                    this.checkIsOpen();
                    this.u_stmt.setAutoCommit(this.u_con.getAutoCommit());
                    UBatchResult results = this.u_stmt.executeBatch(this.query_timeout);
                    this.setShardId(this.u_con.getShardId());
                    this.error = this.u_stmt.getRecentError();
                    switch (this.error.getErrorCode()) {
                        case 0: {
                            break;
                        }
                        default: {
                            throw this.con.createCUBRIDException(this.error);
                        }
                    }
                    this.con.autoCommit();
                    return this.checkBatchResult(results);
                }
            }
        }
        catch (NullPointerException e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public synchronized void setURL(int index, URL x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setOID(int parameterIndex, CUBRIDOID x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindOID(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setCollection(int parameterIndex, Object[] x) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.bindCollection(parameterIndex - 1, x);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CUBRIDOID executeInsert() throws SQLException {
        try {
            CUBRIDConnection cUBRIDConnection = this.con;
            synchronized (cUBRIDConnection) {
                CUBRIDPreparedStatement cUBRIDPreparedStatement = this;
                synchronized (cUBRIDPreparedStatement) {
                    this.setShardId(-1);
                    this.u_con.setBeginTime();
                    this.checkIsOpen();
                    if (!this.completed) {
                        this.complete();
                    }
                    if (this.autoGeneratedKeys == 1 && this.u_stmt.getCommandType() == 20) {
                        this.u_stmt.setAutoGeneratedKeys(true);
                    }
                    CUBRIDOID oid = this.executeInsertCore();
                    this.complete();
                    return oid;
                }
            }
        }
        catch (NullPointerException e) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed);
        }
    }

    public boolean hasResultSet() {
        return this.first_result_type;
    }

    void complete() throws SQLException {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (this.current_result_set != null) {
            this.current_result_set.close();
            this.current_result_set = null;
        }
        this.result_info = null;
        if (this.autoGeneratedKeys == 1) {
            this.con.setAutoGeneratedKeys(true);
        } else {
            this.con.setAutoGeneratedKeys(false);
        }
        this.con.autoCommit();
    }

    protected void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            if (this.con != null) {
                throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed, null);
            }
            throw new CUBRIDException(CUBRIDJDBCErrorCode.prepared_statement_closed, null);
        }
    }

    protected void checkBindError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case -21006: {
                throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_index, null);
            }
            case -21016: {
                throw new IllegalArgumentException();
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

