/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

public class UBatchResult {
    private boolean errorFlag;
    private int resultNumber;
    private int[] result;
    private int[] statementType;
    private int[] errorCode;
    private String[] errorMessage;

    UBatchResult(int number) {
        this.resultNumber = number;
        this.result = new int[this.resultNumber];
        this.statementType = new int[this.resultNumber];
        this.errorCode = new int[this.resultNumber];
        this.errorMessage = new String[this.resultNumber];
        this.errorFlag = false;
    }

    public int[] getErrorCode() {
        return this.errorCode;
    }

    public String[] getErrorMessage() {
        return this.errorMessage;
    }

    public int[] getResult() {
        return this.result;
    }

    public int getResultNumber() {
        return this.resultNumber;
    }

    public int[] getStatementType() {
        return this.statementType;
    }

    synchronized void setResult(int index, int count) {
        if (index < 0 || index >= this.resultNumber) {
            return;
        }
        this.result[index] = count;
        this.errorCode[index] = 0;
        this.errorMessage[index] = null;
    }

    synchronized void setResultError(int index, int code, String message) {
        if (index < 0 || index >= this.resultNumber) {
            return;
        }
        this.result[index] = -3;
        this.errorCode[index] = code;
        this.errorMessage[index] = message;
        this.errorFlag = true;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    synchronized void setStatementType(int index, int type) {
        if (index < 0 || index >= this.resultNumber) {
            return;
        }
        this.statementType[index] = type;
    }
}

