/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.jci.UJciException;
import cubrid.jdbc.jci.UOutputBuffer;
import cubrid.jdbc.jci.UParameter;
import java.io.IOException;

public class UBindParameter
extends UParameter {
    private static final byte PARAM_MODE_UNKNOWN = 0;
    private static final byte PARAM_MODE_IN = 1;
    private static final byte PARAM_MODE_OUT = 2;
    private static final byte PARAM_MODE_INOUT = 3;
    byte[] paramMode;
    private boolean[] isBinded;
    private byte dbmsType;

    UBindParameter(int parameterNumber, byte dbmsType) {
        super(parameterNumber);
        this.isBinded = new boolean[this.number];
        this.dbmsType = dbmsType;
        this.paramMode = new byte[this.number];
        this.clear();
    }

    boolean checkAllBinded() {
        for (int i = 0; i < this.number; ++i) {
            if (this.isBinded[i] || this.paramMode[i] != 0) continue;
            return false;
        }
        return true;
    }

    void clear() {
        for (int i = 0; i < this.number; ++i) {
            this.isBinded[i] = false;
            this.paramMode[i] = 0;
            this.values[i] = null;
            this.types[i] = 0;
        }
    }

    synchronized void close() {
        for (int i = 0; i < this.number; ++i) {
            this.values[i] = null;
        }
        this.isBinded = null;
        this.paramMode = null;
        this.values = null;
        this.types = null;
    }

    synchronized void setParameter(int index, byte bType, Object bValue) throws UJciException {
        if (index < 0 || index >= this.number) {
            throw new UJciException(-21016);
        }
        this.types[index] = bType;
        this.values[index] = bValue;
        this.isBinded[index] = true;
        int n = index;
        this.paramMode[n] = (byte)(this.paramMode[n] | 1);
    }

    void setOutParam(int index, int sqlType) throws UJciException {
        if (index < 0 || index >= this.number) {
            throw new UJciException(-21016);
        }
        if (this.dbmsType == 3 || this.dbmsType == 6) {
            if (sqlType < 0 || sqlType > 28) {
                throw new UJciException(-21016);
            }
            this.types[index] = (byte)sqlType;
        }
        int n = index;
        this.paramMode[n] = (byte)(this.paramMode[n] | 2);
    }

    synchronized void writeParameter(UOutputBuffer outBuffer) throws UJciException {
        try {
            for (int i = 0; i < this.number; ++i) {
                if (!this.isSetDefaultValue(i) && this.values[i] == null) {
                    outBuffer.addByte((byte)0);
                    outBuffer.addNull();
                    continue;
                }
                outBuffer.addByte(this.types[i]);
                outBuffer.writeParameter(this.types[i], this.values[i], this.isSetDefaultValue(i));
            }
        }
        catch (IOException e) {
            throw new UJciException(-21016);
        }
    }

    synchronized void flushLobStreams() {
        for (int i = 0; i < this.number; ++i) {
            if (this.values[i] == null) continue;
            if (this.values[i] instanceof CUBRIDBlob) {
                ((CUBRIDBlob)this.values[i]).flushFlushableStreams();
                continue;
            }
            if (!(this.values[i] instanceof CUBRIDClob)) continue;
            ((CUBRIDClob)this.values[i]).flushFlushableStreams();
        }
    }

    private boolean isSetDefaultValue(int index) {
        return (this.dbmsType == 3 || this.dbmsType == 6) && this.paramMode[index] == 2;
    }
}

