/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UJciException;
import cubrid.sql.CUBRIDOID;
import cubrid.sql.CUBRIDTimestamp;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public abstract class UGetTypeConvertedValue {
    public static BigDecimal getBigDecimal(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof BigDecimal) {
            return (BigDecimal)data;
        }
        if (data instanceof String) {
            try {
                return new BigDecimal((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Long) {
            return new BigDecimal((Long)data);
        }
        if (data instanceof Number) {
            return new BigDecimal(((Number)data).doubleValue());
        }
        if (data instanceof Boolean) {
            return new BigDecimal((Boolean)data == true ? 1.0 : 0.0);
        }
        throw new UJciException(-21005);
    }

    public static boolean getBoolean(Object data) throws UJciException {
        if (data == null) {
            return false;
        }
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        if (data instanceof String) {
            return ((String)data).compareTo("0") != 0;
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue() != 0.0;
        }
        if (data instanceof byte[]) {
            return ((byte[])data)[0] != 0;
        }
        throw new UJciException(-21005);
    }

    public static byte getByte(Object data) throws UJciException {
        if (data == null) {
            return 0;
        }
        if (data instanceof Number) {
            return ((Number)data).byteValue();
        }
        if (data instanceof byte[]) {
            if (((byte[])data).length != 1) {
                throw new UJciException(-21005);
            }
            return ((byte[])data)[0];
        }
        if (data instanceof String) {
            try {
                return Byte.parseByte((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? (byte)-128 : 0;
        }
        throw new UJciException(-21005);
    }

    public static byte[] getBytes(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof byte[]) {
            return (byte[])((byte[])data).clone();
        }
        throw new UJciException(-21005);
    }

    public static Date getDate(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof Date) {
            return new Date(((Date)data).getTime());
        }
        if (data instanceof Timestamp) {
            return new Date(((Timestamp)data).getTime());
        }
        if (data instanceof String) {
            try {
                return Date.valueOf((String)data);
            }
            catch (IllegalArgumentException e) {
                throw new UJciException(-21005);
            }
        }
        throw new UJciException(-21005);
    }

    public static double getDouble(Object data) throws UJciException {
        if (data == null) {
            return 0.0;
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data instanceof String) {
            try {
                return Double.parseDouble((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? 1.0 : 0.0;
        }
        throw new UJciException(-21005);
    }

    public static float getFloat(Object data) throws UJciException {
        if (data == null) {
            return 0.0f;
        }
        if (data instanceof Number) {
            return ((Number)data).floatValue();
        }
        if (data instanceof String) {
            try {
                return Float.parseFloat((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? 1.0f : 0.0f;
        }
        throw new UJciException(-21005);
    }

    public static int getInt(Object data) throws UJciException {
        if (data == null) {
            return 0;
        }
        if (data instanceof Number) {
            return ((Number)data).intValue();
        }
        if (data instanceof String) {
            try {
                return Integer.parseInt((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? 1 : 0;
        }
        throw new UJciException(-21005);
    }

    public static long getLong(Object data) throws UJciException {
        if (data == null) {
            return 0L;
        }
        if (data instanceof String) {
            try {
                return Long.parseLong((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Number) {
            return ((Number)data).longValue();
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? 1L : 0L;
        }
        throw new UJciException(-21005);
    }

    public static short getShort(Object data) throws UJciException {
        if (data == null) {
            return 0;
        }
        if (data instanceof Number) {
            return ((Number)data).shortValue();
        }
        if (data instanceof String) {
            try {
                return Short.parseShort((String)data);
            }
            catch (NumberFormatException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Boolean) {
            return (Boolean)data == true ? (short)1 : 0;
        }
        throw new UJciException(-21005);
    }

    public static String getString(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof BigDecimal) {
            return ((BigDecimal)data).toPlainString();
        }
        if (data instanceof Number || data instanceof Boolean || data instanceof Date || data instanceof Time) {
            return data.toString();
        }
        if (data instanceof Timestamp) {
            String form = CUBRIDTimestamp.isTimestampType((Timestamp)data) ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS";
            SimpleDateFormat f = new SimpleDateFormat(form);
            return f.format(data);
        }
        if (data instanceof CUBRIDOID) {
            try {
                return ((CUBRIDOID)data).getOidString();
            }
            catch (Exception e) {
                return "";
            }
        }
        if (data instanceof byte[]) {
            return UGetTypeConvertedValue.getHexaDecimalString((byte[])data);
        }
        if (data instanceof Blob || data instanceof Clob) {
            return data.toString();
        }
        throw new UJciException(-21005);
    }

    public static Time getTime(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof Time) {
            return new Time(((Time)data).getTime());
        }
        if (data instanceof String) {
            try {
                return Time.valueOf((String)data);
            }
            catch (IllegalArgumentException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Timestamp) {
            return new Time(((Timestamp)data).getTime());
        }
        throw new UJciException(-21005);
    }

    public static Timestamp getTimestamp(Object data) throws UJciException {
        if (data == null) {
            return null;
        }
        if (data instanceof Timestamp) {
            return new Timestamp(((Timestamp)data).getTime());
        }
        if (data instanceof String) {
            try {
                return Timestamp.valueOf((String)data);
            }
            catch (IllegalArgumentException e) {
                throw new UJciException(-21005);
            }
        }
        if (data instanceof Date) {
            return new Timestamp(((Date)data).getTime());
        }
        if (data instanceof Time) {
            return new Timestamp(((Time)data).getTime());
        }
        throw new UJciException(-21005);
    }

    private static String getHexaDecimalString(byte[] data) {
        String stringData = "";
        short temp = 0;
        int aByteSize = 256;
        for (int i = 0; i < data.length; ++i) {
            temp = data[i] < 0 ? (short)((short)data[i] + 256) : (short)data[i];
            String aByteString = "";
            for (int j = 0; j < 2; ++j) {
                int halfByte = temp % 16;
                aByteString = (halfByte < 10 ? String.valueOf(halfByte) : (halfByte == 10 ? "a" : (halfByte == 11 ? "b" : (halfByte == 12 ? "c" : (halfByte == 13 ? "d" : (halfByte == 14 ? "e" : "f")))))) + aByteString;
                temp = (short)(temp / 16);
            }
            stringData = stringData + aByteString;
        }
        return stringData;
    }
}

