/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.JdbcCacheWorker;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UUrlCache;
import cubrid.jdbc.jci.UUrlHostKey;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UJCIManager {
    static String sysCharsetName;
    static Hashtable<UUrlHostKey, UUrlCache> url_cache_table;
    static ArrayList<UUrlCache> url_cache_remove_list;
    static JdbcCacheWorker CACHE_Manager;
    static boolean result_cache_enable;

    public static UConnection connect(String ip, int port, String name, String user, String passwd, String url) throws SQLException {
        UConnection connection = new UConnection(ip, port, name, user, passwd, url);
        return connection;
    }

    public static UConnection connect(ArrayList<String> aConList, String name, String user, String passwd, String url) throws SQLException {
        UConnection connection = new UConnection(aConList, name, user, passwd, url);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UUrlCache getUrlCache(UUrlHostKey key) {
        UUrlCache url_cache = url_cache_table.get(key);
        if (url_cache != null) {
            return url_cache;
        }
        Hashtable<UUrlHostKey, UUrlCache> hashtable = url_cache_table;
        synchronized (hashtable) {
            url_cache = url_cache_table.get(key);
            if (url_cache == null) {
                url_cache = new UUrlCache();
                url_cache_table.put(key, url_cache);
                ArrayList<UUrlCache> arrayList = url_cache_remove_list;
                synchronized (arrayList) {
                    url_cache_remove_list.add(url_cache);
                }
            }
        }
        return url_cache;
    }

    public static UConnection connectDefault() throws SQLException {
        Thread curThread = Thread.currentThread();
        Socket s = (Socket)UJCIUtil.invoke("com.cubrid.jsp.ExecuteThread", "getSocket", null, curThread, null);
        return new UConnection(s, curThread);
    }

    static {
        result_cache_enable = true;
        sysCharsetName = System.getProperty("file.encoding");
        url_cache_table = new Hashtable(10);
        url_cache_remove_list = new ArrayList(10);
        try {
            CACHE_Manager = new JdbcCacheWorker();
            CACHE_Manager.setDaemon(true);
            CACHE_Manager.setContextClassLoader(null);
            CACHE_Manager.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            result_cache_enable = false;
        }
    }
}

