/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UErrorCode;

public class UJciException
extends Exception {
    private static final long serialVersionUID = 4464106407657785825L;
    private int jciErrCode;
    private int serverErrCode;
    private int serverErrIndicator;

    public UJciException(int err) {
        this.jciErrCode = err;
    }

    public UJciException(int err, Throwable t) {
        this.jciErrCode = err;
        this.setStackTrace(t.getStackTrace());
    }

    public UJciException(int err, int indicator, int srv_err, String msg) {
        super(msg);
        this.jciErrCode = err;
        this.serverErrCode = srv_err;
        if (this.serverErrCode <= -100000) {
            this.serverErrCode = -100000 - this.serverErrCode;
        }
        this.serverErrIndicator = indicator;
    }

    void toUError(UError error) {
        error.setStackTrace(this.getStackTrace());
        if (this.jciErrCode == -21002) {
            String msg = this.serverErrIndicator == -2 ? this.getMessage() : UErrorCode.codeToCASMessage(this.serverErrCode);
            error.setDBError(this.serverErrCode, msg);
        } else if (this.jciErrCode == -21023) {
            error.setErrorMessage(this.jciErrCode, this.getMessage());
        } else {
            error.setErrorCode(this.jciErrCode);
        }
    }

    public int getJciError() {
        return this.jciErrCode;
    }

    public String toString() {
        int errorCode;
        String indicator;
        String msg;
        if (this.jciErrCode == -21002) {
            if (this.serverErrIndicator == -2) {
                msg = this.getMessage();
                indicator = "ER_DBMS";
                errorCode = this.serverErrCode;
            } else {
                msg = UErrorCode.codeToCASMessage(this.serverErrCode);
                indicator = "ER_BROKER";
                errorCode = this.jciErrCode;
            }
        } else {
            msg = this.getMessage();
            indicator = "ER_DRIVER";
            errorCode = this.jciErrCode;
        }
        return String.format("%s[%d,%s]", indicator, errorCode, msg);
    }
}

