/*
 * Decompiled with CFR 0.152.
 */
package cubrid.sql;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDResultSet;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UJCIUtil;
import cubrid.jdbc.jci.UStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CUBRIDOID {
    private CUBRIDConnection cur_con;
    private byte[] oid;
    private boolean is_closed;
    private UError error;

    public CUBRIDOID(CUBRIDConnection con, byte[] o) {
        this.cur_con = con;
        this.oid = o;
        this.is_closed = false;
    }

    public CUBRIDOID(CUBRIDOID o) {
        this.cur_con = o.cur_con;
        this.oid = o.oid;
        this.is_closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getValues(String[] attrNames) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        UStatement u_stmt = null;
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_stmt = u_con.getByOID(this, attrNames);
            this.error = u_con.getRecentError();
        }
        this.checkError();
        return new CUBRIDResultSet(u_stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValues(String[] attrNames, Object[] values) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrNames == null || values == null) {
            throw new IllegalArgumentException();
        }
        if (attrNames.length != values.length) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.putByOID(this, attrNames, values);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove() throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.oidCmd(this, (byte)1);
            this.error = u_con.getRecentError();
        }
        this.checkError();
        if (u_con.getAutoCommit()) {
            u_con.turnOnAutoCommitBySelf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isInstance() throws SQLException {
        Object instance_obj;
        UConnection u_con;
        this.checkIsOpen();
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            instance_obj = u_con.oidCmd(this, (byte)2);
            this.error = u_con.getRecentError();
        }
        this.checkError();
        return instance_obj != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReadLock() throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.oidCmd(this, (byte)3);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setWriteLock() throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.oidCmd(this, (byte)4);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSet(String attrName, Object value) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.addElementToSet(this, attrName, value);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSet(String attrName, Object value) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.dropElementInSet(this, attrName, value);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToSequence(String attrName, int index, Object value) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.insertElementIntoSequence(this, attrName, index, value);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void putIntoSequence(String attrName, int index, Object value) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.putElementInSequence(this, attrName, index, value);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeFromSequence(String attrName, int index) throws SQLException {
        UConnection u_con;
        this.checkIsOpen();
        if (attrName == null) {
            throw new IllegalArgumentException();
        }
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            u_con.dropElementInSequence(this, attrName, index);
            this.error = u_con.getRecentError();
        }
        this.checkError();
    }

    public synchronized String getOidString() throws SQLException {
        this.checkIsOpen();
        if (this.oid == null || this.oid.length != 8) {
            return "";
        }
        return "@" + UJCIUtil.bytes2int(this.oid, 0) + "|" + UJCIUtil.bytes2short(this.oid, 4) + "|" + UJCIUtil.bytes2short(this.oid, 6);
    }

    public byte[] getOID() {
        return this.oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getTableName() throws SQLException {
        String tablename;
        UConnection u_con;
        this.checkIsOpen();
        UConnection uConnection = u_con = this.cur_con.getUConnection();
        synchronized (uConnection) {
            tablename = (String)u_con.oidCmd(this, (byte)5);
        }
        return tablename;
    }

    public static CUBRIDOID getNewInstance(CUBRIDConnection con, String oidStr) throws SQLException {
        if (con == null || oidStr == null) {
            throw new IllegalArgumentException();
        }
        if (oidStr.charAt(0) != '@') {
            throw new IllegalArgumentException();
        }
        StringTokenizer oidStringArray = new StringTokenizer(oidStr, "|");
        try {
            int page = Integer.parseInt(oidStringArray.nextToken().substring(1));
            short slot = Short.parseShort(oidStringArray.nextToken());
            short vol = Short.parseShort(oidStringArray.nextToken());
            byte[] bOID = new byte[]{(byte)(page >>> 24 & 0xFF), (byte)(page >>> 16 & 0xFF), (byte)(page >>> 8 & 0xFF), (byte)(page >>> 0 & 0xFF), (byte)(slot >>> 8 & 0xFF), (byte)(slot >>> 0 & 0xFF), (byte)(vol >>> 8 & 0xFF), (byte)(vol >>> 0 & 0xFF)};
            return new CUBRIDOID(con, bOID);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException();
        }
    }

    private void close() throws SQLException {
        if (this.is_closed) {
            return;
        }
        this.is_closed = true;
        this.cur_con = null;
        this.oid = null;
    }

    private void checkIsOpen() throws SQLException {
        if (this.is_closed) {
            throw new CUBRIDException(CUBRIDJDBCErrorCode.oid_closed);
        }
    }

    private void checkError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            case -21017: {
                this.close();
                throw new CUBRIDException(CUBRIDJDBCErrorCode.oid_closed);
            }
            case -21016: {
                throw new IllegalArgumentException();
            }
            default: {
                throw new CUBRIDException(this.error);
            }
        }
    }
}

