/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.TemplatePath;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class Utils {
    private static final String CLASSPATH = "classpath:";

    public static TemplatePath parseTemplateUrl(String templatePath) throws GenerateException {
        TemplatePath tp;
        if (templatePath == null) {
            return null;
        }
        if (templatePath.startsWith(CLASSPATH)) {
            String resPath = templatePath.substring(CLASSPATH.length());
            tp = Utils.extractTemplateObject(resPath);
            tp.loader = new ClassPathTemplateLoader(tp.prefix, tp.suffix);
        } else {
            tp = Utils.extractTemplateObject(templatePath);
            tp.loader = new FileTemplateLoader(tp.prefix, tp.suffix);
        }
        return tp;
    }

    private static TemplatePath extractTemplateObject(String resPath) throws GenerateException {
        int extidx;
        TemplatePath tp = new TemplatePath();
        String prefix = "";
        String suffix = "";
        String name = "";
        int prefixidx = resPath.lastIndexOf("/");
        if (prefixidx != -1) {
            prefix = resPath.substring(0, prefixidx + 1);
        }
        if ((extidx = resPath.lastIndexOf(".")) != -1) {
            suffix = resPath.substring(extidx);
            if (extidx < prefix.length()) {
                throw new GenerateException("You have an interesting template path:" + resPath);
            }
            name = resPath.substring(prefix.length(), extidx);
        }
        tp.name = name;
        tp.prefix = prefix;
        tp.suffix = suffix;
        return tp;
    }

    public static void sortSwagger(Swagger swagger) throws GenerateException {
        if (swagger == null || swagger.getPaths() == null) {
            return;
        }
        TreeMap sortedMap = new TreeMap();
        if (swagger.getPaths() == null) {
            return;
        }
        sortedMap.putAll(swagger.getPaths());
        swagger.paths(sortedMap);
        for (Path path : swagger.getPaths().values()) {
            String[] methods;
            for (String m : methods = new String[]{"Get", "Delete", "Post", "Put", "Options", "Patch"}) {
                Utils.sortResponses(path, m);
            }
        }
        if (swagger.getDefinitions() != null) {
            TreeMap defs = new TreeMap();
            defs.putAll(swagger.getDefinitions());
            swagger.setDefinitions(defs);
        }
        if (swagger.getTags() != null) {
            Collections.sort(swagger.getTags(), new Comparator<Tag>(){

                @Override
                public int compare(Tag a, Tag b) {
                    return a.toString().toLowerCase().compareTo(b.toString().toLowerCase());
                }
            });
        }
    }

    private static void sortResponses(Path path, String method) throws GenerateException {
        try {
            Method m = Path.class.getDeclaredMethod("get" + method, new Class[0]);
            Operation op = (Operation)m.invoke((Object)path, new Object[0]);
            if (op == null) {
                return;
            }
            Map responses = op.getResponses();
            TreeMap res = new TreeMap();
            res.putAll(responses);
            op.setResponses(res);
        }
        catch (NoSuchMethodException e) {
            throw new GenerateException(e);
        }
        catch (InvocationTargetException e) {
            throw new GenerateException(e);
        }
        catch (IllegalAccessException e) {
            throw new GenerateException(e);
        }
    }
}

